/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredFunction;
import com.complexible.stardog.StoredFunctions;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.util.Comparator;

@Command(name="list", description="Lists the functions currently stored in the system.", examples={"* Lists the stored functions and their definitions:", "    $ stardog-admin function list"})
public final class StoredFunctionList
extends SecureStardogAdminCommand<Void> {
    @Inject
    protected StoredFunctionList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        StoredFunctions aStoredFunctions = theConn.getStoredFunctions();
        Comparator<StoredFunction> aComparator = Comparator.comparing(StoredFunction::getName);
        ImmutableList aSortedFunctions = Ordering.from(aComparator).immutableSortedCopy((Iterable)aStoredFunctions);
        if (aSortedFunctions.isEmpty()) {
            System.out.println("No stored functions");
        } else {
            for (StoredFunction aFunc : aSortedFunctions) {
                System.out.println(aFunc.getDefinition());
            }
        }
    }
}

