/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.ImmutableStoredFunction;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredFunctions;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.server.FunctionExistsException;
import com.complexible.stardog.server.FunctionNotFoundException;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;

@Command(name="add", description="Adds a new stored function", discussion="Adds a new stored function. Stored functions assign a name to a SPARQL function expression and allows the expression to be executed in a SPARQL query by using the name. Stored functions can be used to query any database.", examples={"* Adds a new stored function:", "    $ stardog-admin function add \"function permutation(?n, ?r) { factorial(?n) / factorial(?n - ?r) }\"", "", "* Adds a new stored function overwriting previous function with same name:", "    $ stardog-admin function add --overwrite \"function combination(?n, ?r) { permutation(?n, ?r) / factorial(?r) }\"", "", "* Adds multiple stored functions:", "    $ stardog-admin function add \"function permutation(?n, ?r) { factorial(?n) / factorial(?n - ?r) } \\ \n                                   function combination(?n, ?r) { permutation(?n, ?r) / factorial(?r) }\""})
public final class StoredFunctionAdd
extends SecureStardogAdminCommand<Void> {
    @Option(name={"--overwrite"}, description="Overwrite an existing stored function with the same name.")
    public boolean mOverwrite = false;
    @Arguments(required=true, title={"function"}, description="The definition of the stored function in the format \"FUNCTION name([parameter[, parameter]*]) { <SPARQL expression> }\".")
    public String mFunctionDefn;

    @Inject
    public StoredFunctionAdd(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        StoredFunctions aStoredFunctions = theConn.getStoredFunctions();
        List functions = ImmutableStoredFunction.parse((String)this.mFunctionDefn);
        if (this.mOverwrite) {
            for (ImmutableStoredFunction function : functions) {
                try {
                    aStoredFunctions.remove(function.getName());
                }
                catch (FunctionNotFoundException functionNotFoundException) {}
            }
        }
        try {
            aStoredFunctions.load(this.mFunctionDefn);
            String msg = functions.size() == 1 ? "1 function" : functions.size() + " functions";
            System.out.println(StoredFunctionAdd.get("stored.added", msg));
        }
        catch (FunctionExistsException e) {
            throw new CliException(StoredFunctionAdd.get("stored.overwrite", "Function"));
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, StardogException.class);
            throw new CliException(e);
        }
    }
}

