/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.StardogAdminSecureDatabase;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.index.IndexOptions;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metrics.MetricsNaming;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Command(name="status", description="Shows status information regarding the given database.", examples={"* Show the status of the database 'myDb':", "    $ stardog-admin db status myDb"})
public final class Status
extends StardogAdminSecureDatabase<Void> {
    @Inject
    protected Status(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        List<MetaProperty> aOptions = Arrays.asList(DatabaseOptions.CREATION_TIME, DatabaseOptions.ONLINE, IndexOptions.SIZE);
        Metadata aOptionValues = theConn.get(this.mDatabase, aOptions);
        String FORMAT = "%-21s: ";
        System.out.format("%-21s: ", "Database").println(this.mDatabase);
        Map aStatus = theConn.currentStatus(true);
        System.out.format("%-21s: ", "Status").println(MoreObjects.firstNonNull(aStatus.get(MetricsNaming.Database.state((String)this.mDatabase)), (Object)"Offline"));
        System.out.format("%-21s: ", "Approx. size").println(String.valueOf(aOptionValues.get((MetaProperty)IndexOptions.SIZE)) + " triples");
        System.out.format("%-21s: ", "Queries").println(this.getRunningQueryList(theConn, this.mDatabase));
        System.out.format("%-21s: ", Status.get("openConnections", new Object[0])).println(MoreObjects.firstNonNull(aStatus.get(MetricsNaming.Database.openConnections((String)this.mDatabase)), (Object)0));
        System.out.format("%-21s: ", Status.get("openTransactions", new Object[0])).println(MoreObjects.firstNonNull(aStatus.get(MetricsNaming.Database.openTransactions((String)this.mDatabase)), (Object)0));
        Map queryStats = (Map)aStatus.get(MetricsNaming.Database.queries((String)this.mDatabase));
        if (queryStats != null) {
            System.out.format("%-21s: ", Status.get("avgQueryTime", new Object[0])).format("%,.2f s%n", MoreObjects.firstNonNull((Object)((Double)queryStats.get("mean")), (Object)0.0));
            System.out.format("%-21s: ", Status.get("qps", new Object[0])).format("%,.2f queries/sec%n", MoreObjects.firstNonNull((Object)((Double)queryStats.get("mean_rate")), (Object)0.0));
        }
        System.out.format("%-21s: ", Status.get("planCacheSize", new Object[0])).format("%d%n", MoreObjects.firstNonNull((Object)((Long)aStatus.get(MetricsNaming.Database.planCache((String)this.mDatabase) + ".size")), (Object)0L));
        Double aRatio = (Double)MoreObjects.firstNonNull((Object)((Double)aStatus.get(MetricsNaming.Database.planCache((String)this.mDatabase) + ".ratio")), (Object)Double.NaN);
        System.out.format("%-21s: ", Status.get("planCacheRatio", new Object[0])).format("%,.2f%%%n", aRatio.isNaN() ? 0.0 : 100.0 * aRatio);
    }

    private String getRunningQueryList(AdminConnection theConn, String theDatabase) throws StardogException {
        ArrayList aQueries = Lists.newArrayList();
        for (QueryInfo aInfo : theConn.getQueryManager().getAllQueries()) {
            if (!aInfo.getDBName().equals(theDatabase)) continue;
            aQueries.add(aInfo.getID());
        }
        return aQueries.isEmpty() ? "None running" : ((Object)aQueries).toString();
    }
}

