/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.SimpleQueryCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.OptionType;
import java.text.NumberFormat;

@Command(name="size", description="Returns the number of triples in the database.", examples={"* Return the size of the database 'myDb':", "    $ stardog data size myDb"})
public final class Size
extends SimpleQueryCommand<Void> {
    @Option(name={"--exact"}, type=OptionType.COMMAND, description="Ensures that the returned value is exact at the time of the call. This may require the server to scan the entire database", arity=0)
    protected boolean mExact = false;

    @Inject
    public Size(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        NumberFormat aNumberFormat = NumberFormat.getNumberInstance();
        System.out.println(Size.get("size.msg.results" + (this.mExact ? ".exact" : ""), aNumberFormat.format(theConn.size())));
    }

    @Override
    protected boolean isExactSize() {
        return this.mExact;
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }
}

