/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.Column;
import com.complexible.common.base.Memory;
import com.complexible.common.base.Numbers;
import com.complexible.common.dataexporter.Columns;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.metrics.MetricsNaming;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.time.DurationFormatUtils;

@Command(name="status", description="Retrieves the current status information from the Stardog DBMS", examples={"* Get the DBMS current status information", "    $ stardog-admin server status"})
public final class ServerStatus
extends SecureStardogAdminCommand<Void> {
    @Inject
    public ServerStatus(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        ServerStatus.printStatus(theConn.currentStatus(true));
    }

    public static void printStatus(Map<String, Object> theStatus) {
        TreeMap aLineMap = Maps.newTreeMap();
        TreeSet aDbs = Sets.newTreeSet();
        String aDbPrefix = "databases";
        Splitter aSplitter = Splitter.on((char)'.');
        for (String aPropName : theStatus.keySet()) {
            if (aPropName.startsWith("databases")) {
                String aDb = (String)Iterables.get((Iterable)aSplitter.splitToList((CharSequence)aPropName), (int)1, null);
                if (aDb == null || !aPropName.equals(MetricsNaming.Database.queries((String)aDb))) continue;
                aDbs.add(aDb);
                continue;
            }
            Object aVal = theStatus.get(aPropName);
            String aPropLabel = ServerStatus.get(aPropName, new Object[0]);
            if (aPropLabel.equals(aPropName)) continue;
            String aPropValue = MetricsNaming.Kernel.systemUptime().equals(aPropName) ? DurationFormatUtils.formatDurationWords((long)((Long)aVal), (boolean)true, (boolean)false) : (MetricsNaming.Kernel.systemCpuUsage().equals(aPropName) ? String.format("%3.2f %%", 100.0 * (Double)aVal) : aVal.toString());
            aLineMap.put(aPropLabel, aPropValue);
        }
        Long aMemoryRSS = (Long)theStatus.get(MetricsNaming.Kernel.memRss());
        if (aMemoryRSS != null) {
            aLineMap.put(ServerStatus.get("dbms.memory.rss", new Object[0]), ServerStatus.formatMem(aMemoryRSS));
        }
        ServerStatus.formatMemUsage(aLineMap, "dbms.memory.heap", theStatus, MetricsNaming.Kernel.memHeapUsed(), MetricsNaming.Kernel.memHeapMax());
        ServerStatus.formatMemUsage(aLineMap, "dbms.memory.native", theStatus, MetricsNaming.Kernel.memNativeUsed(), MetricsNaming.Kernel.memNativeMax());
        ServerStatus.formatMemUsage(aLineMap, "dbms.memory.heap.query.blocks", theStatus, MetricsNaming.Kernel.memHeapQueryBlocksUsed(), MetricsNaming.Kernel.memHeapQueryBlocksMax());
        ServerStatus.formatMemUsage(aLineMap, "dbms.memory.native.query.blocks", theStatus, MetricsNaming.Kernel.memNativeQueryBlocksUsed(), MetricsNaming.Kernel.memNativeQueryBlocksMax());
        aLineMap.forEach((k, v) -> System.out.printf("%-25s: %s%n", k, v));
        if (!aDbs.isEmpty()) {
            System.out.printf("%-25s:%n", "Databases");
            List<Column> aColumns = Arrays.asList(Columns.string((String)"Database"), Columns.integer((String)"Connections"), Columns.merge((String)"Transactions", (Column[])new Column[]{Columns.integer((String)"Open"), Columns.integer((String)"Total"), Columns.string((String)"Avg. Size", (AlignType)AlignType.TOP_RIGHT), Columns.decimal((String)"Avg. Time (s)", (int)3), Columns.decimal((String)"Rate/sec", (int)3)}), Columns.merge((String)"Queries", (Column[])new Column[]{Columns.integer((String)"Running"), Columns.integer((String)"Total"), Columns.decimal((String)"Avg. Time (s)", (int)3), Columns.decimal((String)"Rate/sec", (int)3)}));
            TextTabularOutput table = new TextTabularOutput((OutputStream)System.out, aColumns);
            for (String aDb : aDbs) {
                Map aQueryTimer = (Map)theStatus.get(MetricsNaming.Database.queries((String)aDb));
                Map aTxTimer = (Map)theStatus.get(MetricsNaming.Database.txTimer((String)aDb));
                Map aTxSize = (Map)theStatus.getOrDefault(MetricsNaming.Database.txSize((String)aDb), ImmutableMap.of());
                table.addRow(new Object[]{aDb, theStatus.get(MetricsNaming.Database.openConnections((String)aDb)), theStatus.get(MetricsNaming.Database.openTransactions((String)aDb)), aTxTimer.get("count"), ServerStatus.readable(aTxSize.get("mean")), aTxTimer.get("mean"), aTxTimer.get("mean_rate"), theStatus.get(MetricsNaming.Database.runningQueries((String)aDb)), aQueryTimer.get("count"), aQueryTimer.get("mean"), aQueryTimer.get("mean_rate")});
            }
            table.output();
        }
    }

    private static String readable(Object number) {
        return number == null ? "N/A" : (number instanceof Number ? Numbers.readable((long)((Number)number).longValue()) : number.toString());
    }

    private static void formatMemUsage(Map<String, String> theMap, String theProp, Map<String, Object> theStatus, String used, String max) {
        Long aUsed = (Long)theStatus.get(used);
        Long aMax = (Long)theStatus.get(max);
        if (aUsed != null && aMax != null && aMax > 0L) {
            String aValue = String.format("%4s (%s: %4s)", ServerStatus.formatMem(aUsed), ServerStatus.get("dbms.memory.max", new Object[0]), ServerStatus.formatMem(aMax));
            theMap.put(ServerStatus.get(theProp, new Object[0]), aValue);
        }
    }

    private static String formatMem(Long theMem) {
        return theMem == null ? "N/A" : Memory.readable((long)theMem);
    }
}

