/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.metrics.MetricOptions;
import com.complexible.stardog.util.report.MetricsPrinter;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;

@Command(name="metrics", description="Retrieves server metrics", discussion="Reports server metrics. Metrics are organized using a dot-delimited namespace system. Top-level namespaces include: admin.threads (thread management for admin HTTP operations), com.stardog.http.server.<port> (HTTP statistics), user.threads (thread management for user HTTP operations), databases.<dbname> (metrics for specific databases), dbms (process and memory metrics), system (system info). See https://www.stardog.com/docs/#_metrics_in_stardog_7 for descriptions of specific metrics.", examples={"* Display all metrics:", "$ stardog-admin server metrics", "", "* Display dbms.credentials.cache.size metric:", "$ stardog-admin server metrics dbms.credentials.cache.size", "", "* Display dbms.credentials.cache.size metric and metrics matching the pattern dbms.mem.*:", "$ stardog-admin server metrics dbms.credentials.cache.size \"dbms.mem.*\"", "", "* Display metrics matching dbms.mem.* and dbms.memory.*:", "$ stardog-admin server metrics \"dbms.mem.*\" \"dbms.memory.*\"", "", "* Get the thread dump from the server:", "$ stardog-admin server metrics --threads \"jvm.threads\"", ""})
public final class ServerMetrics
extends SecureStardogAdminCommand<Void> {
    @Option(name={"--no-databases"}, description="Do not include database-specific metrics and instead only return server-wide metrics. By defaultdatabase details will be shown.", arity=0)
    protected boolean noDB = false;
    @Option(name={"--threads"}, description="Include the thread dump from the server.", arity=0)
    protected boolean threads = false;
    @Option(name={"--locks"}, description="locked monitors and locked synchronizers in the thread dump. Takes effect only if --threads is provided.", arity=0)
    protected boolean locks = false;
    @Option(name={"--samples"}, description="Include detailed sample information for each meter and histogram.", arity=0)
    protected boolean samples = false;
    @Arguments(title={"Selected Metrics"}, description="Display only metrics, matching the specified patterns.", usage="<space-separated metric name regex patterns> (see command examples)")
    public List<String> selectedMetricPatterns;

    @Inject
    public ServerMetrics(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        Options options = Options.create().set(MetricOptions.DATABASES, (Object)(!this.noDB ? 1 : 0)).set(MetricOptions.THREADS, (Object)this.threads).set(MetricOptions.LOCKS, (Object)this.locks).set(MetricOptions.SAMPLES, (Object)this.samples);
        ServerMetrics.printMetrics(theConn.currentStatus(options), this.selectedMetricPatterns);
    }

    public static void printMetrics(Map<String, Object> theMetrics, List<String> theSelectedMetricPatterns) throws StardogException {
        MetricsPrinter.printMetrics((PrintStream)System.out, theMetrics, theSelectedMetricPatterns);
    }
}

