/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Numbers;
import com.complexible.common.base.Options;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.util.report.LogRetriever;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Command(name="logs", description="Retrieves server logs and returns them in a zip file.", discussion="This command is similar to diagnostic report but does not include any configuration or system files in its output. Also, this command requires a running Stardog server to retrieve the logs. If the provided server URL is a cluster, log files from every cluster member will be included in the zip file.", examples={"* Retrieves default Stardog logs.", "    $ stardog-admin --server http://example.com:5820 server logs", "", "* Retrieves all Stardog logs including rotated (archived) logs.", "    $ stardog-admin --server http://example.com:5820 server logs --all --rotated", "", "* Retrieves only the last 1K lines from default set of logs.", "    $ stardog-admin --server http://example.com:5820 server logs --lines 1k", ""})
public class ServerLogs
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-o", "--output"}, title="outputFile", description="The path to the report output file. By default, the command will create a file called stardog-report_YYYY-MM-DD_hh-mm-ss.zip in your current directory. When using this parameter, you must specify a full file path.")
    public String outputFile;
    @Option(name={"-n", "--lines"}, title="number", description="The maximum number of lines from the end of each log file to return. Rotated log files cannot be returned if this option is used. Only the last N lines from the most recent log files will be returned.")
    public String lineCount = null;
    @Option(name={"-r", "--rotated"}, description="Include rotated (archived) logs in the output.")
    public boolean rotateLogs = false;
    @Option(name={"-a", "--all"}, description="Include all log types in the output. This is a shortcut to include all log types in '--log-types' option. This option will not cause rotated logs to be included.")
    public boolean allLogs = false;
    @Option(name={"-t", "--types"}, title="type", description="Specify the exact type of log files to include in the output. Multiple log files can be specified. Allowed values are [stardog, starrocks, audit, gc, sdu_usage]. By default, 'stardog', 'starrocks', and 'gc' logs are returned. The 'stardog' logs contain the logs from the Java layer including zookeeper. The 'starrocks' logs contain the logs from the C++ layer including RocksDB. The 'gc' logs are the standard JVM garbage-collection logs. The 'audit' logs contain server operations in a structured format. The 'sdu_usage' logs contain SDU (Stardog Unit) usage events.", arity=0x7FFFFFFF)
    public Set<String> logTypeNames = Sets.newHashSet();

    @Inject
    public ServerLogs(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws Exception {
        if (this.lineCount != null && this.rotateLogs) {
            throw new CliException("The options '--lines' and '--rotated' cannot be used together.");
        }
        EnumSet<LogRetriever.LogType> logTypes = this.allLogs ? EnumSet.allOf(LogRetriever.LogType.class) : (this.logTypeNames.isEmpty() ? (Set)LogRetriever.Options.LOG_TYPES.getDefaultValue() : this.logTypeNames.stream().map(name -> LogRetriever.LogType.valueOf((String)name.toUpperCase())).collect(Collectors.toSet()));
        Integer lineCount = Optional.ofNullable(this.lineCount).map(Numbers::fromReadable).map(Number::intValue).orElse(null);
        Options options = Options.create().set(LogRetriever.Options.OUTPUT_FILE, (Object)this.outputFile).set(LogRetriever.Options.LINE_COUNT, (Object)lineCount).set(LogRetriever.Options.INCLUDE_ROTATED_LOGS, (Object)this.rotateLogs).set(LogRetriever.Options.LOG_TYPES, logTypes);
        Path file = theConn.getLogs(options);
        System.out.println("Logs saved to output file: " + String.valueOf(file));
    }
}

