/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.api.admin.DefaultSensitivePropertyManager;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;

@Command(name="list", description="List the sensitive properties.", examples={"* List the sensitive properties for the database:", "    $ stardog sensitive-property list myDB", ""})
public final class SensitivePropertyList
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https.", title={"database name"})
    public String mDbName;

    @Inject
    public SensitivePropertyList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        DefaultSensitivePropertyManager aMgr = new DefaultSensitivePropertyManager(theConn);
        List aGroups = Ordering.usingToString().sortedCopy((Iterable)aMgr.getGroups());
        if (aGroups.isEmpty()) {
            System.out.println("No sensitive properties have been defined for the database");
            return;
        }
        NamespacesInfo aNamespaces = theConn.namespaces();
        TurtleValueWriter aWriter = new TurtleValueWriter((Iterable)aNamespaces);
        String[] aColumns = new String[]{"Group", "Properties"};
        TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, aColumns);
        for (String aGroup : aGroups) {
            String aSortedProperties = aMgr.getProperties(aGroup).stream().map(arg_0 -> ((TurtleValueWriter)aWriter).write(arg_0)).sorted().collect(Collectors.joining(", "));
            Object[] aRow = new Object[]{aGroup, aSortedProperties};
            aTable.addRow(aRow);
        }
        aTable.output();
    }
}

