/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.api.admin.DefaultSensitivePropertyManager;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Command(name="add", description="Add new sensitive properties.", examples={"* Define a new additional sensitive property for the database:", "    $ stardog sensitive-property add myDB ex:prop1", "", "* Define two sensitive properties for the database overriding any previous :", "    $ stardog sensitive-property add --overwrite myDB ex:prop1 ex:prop2", "", "* Define a sensitive property for a named group:", "    $ stardog sensitive-property add --group myGroup myDB ex:myProp", ""})
public final class SensitivePropertyAdd
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. Subsequent arguments are the sensitive properties to add. The properties can be specified as full IRIs (no angle brackets needed) or as prefixed names using database namespaces.", title={"database name", "properties"})
    public List<String> mArgs;
    @Option(name={"-g", "--group"}, title="group", description="Name of the sensitive property group. If not provided the properties will be added to the default group.")
    public String mGroup = "";
    @Option(name={"--overwrite"}, description="Overwrite existing set of sensitive properties.", arity=0)
    public boolean isOverwrite = false;
    private String mDbName = null;
    private List<String> mProperties = Lists.newArrayList();

    @Inject
    public SensitivePropertyAdd(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                this.mProperties = this.mArgs.subList(1, this.mArgs.size());
            }
        }
        return this.mDbName;
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        if (this.mProperties.isEmpty()) {
            throw new CliException("No property specified!");
        }
        NamespacesInfo aNamespaces = theConn.namespaces();
        DefaultSensitivePropertyManager aMgr = new DefaultSensitivePropertyManager(theConn);
        HashSet aProps = Sets.newHashSet();
        if (!this.isOverwrite) {
            aProps.addAll(aMgr.getProperties(this.mGroup));
        }
        int aSize = aProps.size();
        aProps.addAll(CliUtil.readIRIs(this.mProperties, (Iterable<Namespace>)aNamespaces));
        int aAddedCount = aProps.size() - aSize;
        aMgr.setProperties(this.mGroup, (Set)aProps);
        String aGroupName = "".equals(this.mGroup) ? "default group" : "group " + this.mGroup;
        System.out.println(aAddedCount + " sensitive properties have been added to the " + aGroupName);
    }
}

