/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.Permission;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.Collection;

@Command(name="permission", description="Lists the permissions associated to a role.")
public final class RolePermission
extends Permission {
    @Arguments(required=true, description="Role whose permissions are to be retrieved.", title={"role name"})
    public String mRolename;

    @Inject
    public RolePermission(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            Collection permissions = theConn.getPermissionManager().getRolePerms(this.mRolename);
            if (permissions.isEmpty()) {
                System.out.println(RolePermission.get("role.no.permissions", this.mRolename));
            } else {
                this.outputPermissionStrings(permissions);
            }
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(RolePermission.get("role.permission.no.such.role", this.mRolename));
        }
    }
}

