/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@Command(name="list", description="Lists all roles.")
public final class RoleList
extends SecureStardogAdminCommand<Void> {
    private static final String[] SIMPLE_VIEW_COLS = new String[]{"Role"};
    private static final String[] ALL_VIEW_COLS = new String[]{"Role", "Users"};

    @Inject
    public RoleList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        String[] aCols = this.mVerbose ? ALL_VIEW_COLS : SIMPLE_VIEW_COLS;
        TextTabularOutput aOutput = new TextTabularOutput((OutputStream)System.out, aCols);
        ArrayList aRoles = Lists.newArrayList((Iterable)theConn.getRoleManager().getAllRoles());
        Collections.sort(aRoles);
        for (String aRole : aRoles) {
            Object[] aRow = new Object[aCols.length];
            aRow[0] = aRole;
            if (this.mVerbose) {
                this.printAllInfo(theConn, aRole, aRow);
            }
            aOutput.addRow(aRow);
        }
        aOutput.output();
    }

    private void printAllInfo(AdminConnection theConn, String theRole, Object[] aRow) {
        Collection<Object> aUsers = Collections.emptyList();
        try {
            aUsers = theConn.getRoleManager().getUsersWithRole(theRole);
        }
        catch (StardogException stardogException) {
            // empty catch block
        }
        int aCurrentCol = 1;
        StringBuffer aUserString = new StringBuffer();
        boolean aFirstUser = true;
        for (String string : aUsers) {
            if (!aFirstUser) {
                aUserString.append(",");
            }
            aFirstUser = false;
            aUserString.append(string);
        }
        aRow[aCurrentCol++] = aUserString.toString();
    }
}

