/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.Permissions;
import com.complexible.stardog.security.ResourceExistsException;
import com.complexible.stardog.security.ResourceInvalidNameException;
import com.complexible.stardog.security.ResourceInvalidTypeException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.complexible.stardog.security.SecurityResourceType;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;

@Command(name="grant", description="Grants a permission to a role.", discussion="Grants the specified permission to the role.  Only one action (-a/--action) can be specified per role grant.", examples={"* Grant the 'aRoleName' role the 'create' permission over db:*, ie, the permission to create databases", "    $ stardog-admin role grant -a create -o db:* aRoleName"})
public final class RoleGrant
extends SecureStardogAdminCommand<Void> {
    public static final String PERMISSION_ACTIONS = "[read,write,create,delete,grant,revoke,execute,all]";
    @Option(required=true, name={"-a", "--action"}, arity=1, description="Action to be permitted: [read,write,create,delete,grant,revoke,execute,all].", title="action")
    public List<String> mAction;
    @Option(required=true, name={"-o", "--object"}, description="Target resource (user:username, db:databasename).", title="obj")
    public String mObject;
    @Arguments(required=true, description="Role to which the permission is to be added.", title={"role name"})
    public String mRole;

    @Inject
    public RoleGrant(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        ActionType aActionType;
        if (this.mAction.isEmpty()) {
            throw new CliException("grant.missing.action");
        }
        String aFirst = (String)Iterables.getFirst(this.mAction, null);
        if (this.mAction.size() > 1) {
            System.out.println(RoleGrant.get("grant.multiple.values", aFirst));
        }
        if ((aActionType = this.getActionType(aFirst)) == null) {
            throw new CliException(RoleGrant.get("grant.invalid.action", this.mAction));
        }
        SecurityResourceType aResourceType = this.getResourceType(this.mObject);
        String aResourceName = this.getResourceName(this.mObject);
        try {
            theConn.getPermissionManager().addRolePerm(Permissions.create((String)this.mRole, (ActionType)aActionType, (SecurityResourceType)aResourceType, (String)aResourceName, (String[])new String[0]));
            System.out.println(RoleGrant.get("grant.success", new Object[0]));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(e.getMessage());
        }
        catch (ResourceExistsException e) {
            throw new CliException(RoleGrant.get("grant.permission.already.exists", "Role", this.mRole));
        }
        catch (ResourceInvalidTypeException e) {
            throw new CliException(RoleGrant.get("grant.invalid.resource.type", aResourceType.id()));
        }
        catch (ResourceInvalidNameException e) {
            throw new CliException(RoleGrant.get("grant.invalid.resource.name", aResourceName));
        }
    }
}

