/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ResourceInUseException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="remove", description="Removes an existing user role.", discussion="A role cannot be removed if it is in use by one or more users of the system. If a role to be dropped is in use, you must either manually remove all existing role assignments or use the force '--force' flag, which will automatically remove all role assignments before deleting the role.")
public final class RoleDrop
extends SecureStardogAdminCommand<Void> {
    @Option(name={"--force", "-f"}, description="Force removal flag. If this flag is set, the role and all role assignments concerning it will be removed.", arity=0)
    public boolean mForce = false;
    @Arguments(description="Role to remove.", title={"role name"}, required=true)
    public String mRole;

    @Inject
    public RoleDrop(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            theConn.getRoleManager().deleteRole(this.mRole, this.mForce);
            System.out.println(RoleDrop.get("role.drop.success", this.mRole));
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(RoleDrop.get("role.drop.no.such.role", this.mRole));
        }
        catch (ResourceInUseException e) {
            if (this.mForce) {
                throw new CliException(RoleDrop.get("role.drop.in.use.after.force", this.mRole));
            }
            throw new CliException(RoleDrop.get("role.drop.in.use.no.force", this.mRole));
        }
    }
}

