/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ResourceExistsException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="add", description="Adds a new role.")
public final class RoleAdd
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="Role to add.", title={"role"}, required=true)
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mRole;

    @Inject
    public RoleAdd(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        try {
            if (this.mRole.length() > 4095) {
                throw new CliException(RoleAdd.get("role.add.length.limit.exceeded", this.mRole));
            }
            theConn.getRoleManager().addRole(this.mRole);
            System.out.println(RoleAdd.get("role.add.success", this.mRole));
        }
        catch (ResourceExistsException e) {
            throw new CliException(RoleAdd.get("role.add.already.exists", this.mRole));
        }
    }
}

