/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="restore", description="Restore a database from a backup.", discussion="Restores a database from its backup.  The location of the backup should be the full path to the backup, not the location of the backup directory as specified in your Stardog configuration. By default, the name of a database is saved in its backup, so there is no need to specify a name for the restored database.  However, if you wish to restore the backup to a different database, a new name can be provided, which must be unique.  A backup will not be restored over an existing database of the same name, to force an overwrite using the restored database, use the -o/--overwrite flag.  You cannot overwrite and specify a new name. If overwrite is not specified, and a new name is not provided, and a database with the name of the database to be restored already exists, the restore operation will not succeed. Overwriting an existing database, while concurrently reading from the database is possible, butany writes committed to the database while the restore is taking place will be lost.\nIn the cluster this command can only be used for file-based backups if there is a single node. It cannot be used for file-based backups in clusters with more than 1 node.", examples={"* Restore a database from its backup:", "    $ stardog-admin db restore $STARDOG_HOME/.backup/myDb/2012-06-21", "", "* Restore a database to a new copy:", "    $ stardog-admin db restore --name restoredMyDb $STARDOG_HOME/.backup/myDb/2012-06-21"})
public final class Restore
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-n", "--name"}, title="new name", description="Specify a new name for the restored database")
    public String mName;
    @Option(name={"-o", "--overwrite"}, title="overwrite existing", description="If the database being restored already exists, overwrite the existing copy with the restored version. Note that data written to the database, _while_ restoring takes place might be lost.")
    public boolean mOverwrite = false;
    @Arguments(description="The full path on disk or the URL of the backup to restore", required=true, title={"backup location"})
    public String mBackup;

    @Inject
    public Restore(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        if (this.mBackup == null) {
            throw new CliException(Restore.get("restore.missing.backup.location", new Object[0]));
        }
        if (this.mName != null && this.mOverwrite) {
            throw new CliException(Restore.get("restore.no.overwrite.and.rename", new Object[0]));
        }
        System.out.println(theConn.restore(this.mBackup, this.mOverwrite, this.mName));
    }
}

