/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.Collection;

@Command(name="rename", description="Rename an existing database.", discussion="Rename an existing database to be identified by a new name.The target name must not already exist. The database must be offline before it can be renamed.The client has to manually offline and online the database.", examples={"* Rename an existing database to be identified by a new name:", "    $ stardog-admin db offline my-database", "    $ stardog-admin db rename --from my-database --to my-new-database", "    $ stardog-admin db online my-new-database", ""})
public final class RenameDatabase
extends SecureStardogAdminCommand<Void> {
    @Option(name={"--from"}, title="From database name", description=".", required=true)
    public String mFromDatabase;
    @Option(name={"--to"}, title="To database name", description=".", required=true)
    public String mToDatabase;

    @Inject
    public RenameDatabase(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        Collection list = theConn.list();
        if (!list.contains(this.mFromDatabase)) {
            System.out.println(RenameDatabase.get("rename.error.from.name.missing", this.mFromDatabase));
            return;
        }
        if (list.contains(this.mToDatabase)) {
            System.out.println(RenameDatabase.get("rename.error.new.name.exists", this.mToDatabase));
            return;
        }
        theConn.renameDatabase(this.mFromDatabase, this.mToDatabase);
        System.out.println(RenameDatabase.get("rename.success", this.mFromDatabase, this.mToDatabase));
    }
}

