/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.IO;
import com.complexible.stardog.api.Remover;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ModifyDataWithFiles;
import com.google.inject.Inject;
import com.stardog.stark.Resource;
import com.stardog.stark.Values;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.OptionType;

@Command(name="remove", description="Removes RDF from a database; prints status on STDOUT.", discussion="Removes data from the database in a single commit. The remove operation is atomic: if multiple files are being removed from the database and there is an error removing one or more of the files, the entire operation will be rolled back.", examples={"* Clear all contents of the database 'myDb':", "    $ stardog data remove --all myDb", "", "* Remove data from the default graph of the database 'myDb':", "    $ stardog data remove myDb file.rdf", "", "* Remove all data from a specific named graph of the database 'myDb':", "    $ stardog data remove --named-graph http://example.org/context myDb", "", "* Remove data from files from a specific named graph of the database 'myDb':", "    $ stardog data remove --named-graph http://example.org/context myDb file1.rdf file2.rdf"})
public final class Remove
extends ModifyDataWithFiles {
    @Option(name={"-a", "--all"}, type=OptionType.COMMAND, description="Remove all flag. If this flag is set, all data in the database will be removed.", arity=0)
    protected boolean mAll = false;

    @Inject
    public Remove(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        boolean isInTx;
        long aStartTime = System.currentTimeMillis();
        boolean bl = isInTx = this.mTxId != null;
        if (!isInTx) {
            theConn.begin();
        }
        try {
            boolean aIsGraph;
            Remover aRemover = theConn.remove();
            boolean aNoFiles = this.mFiles == null || this.mFiles.isEmpty();
            boolean bl2 = aIsGraph = this.mNamedGraph != null && !this.mNamedGraph.equals("");
            if (this.mAll) {
                aRemover.all();
            } else if (aNoFiles && aIsGraph) {
                aRemover.context((Resource)Values.iri((String)this.mNamedGraph));
            } else {
                if (aNoFiles) {
                    throw new CliException(Remove.get("remove.error.nofiles", new Object[0]));
                }
                IO aIO = aRemover.io();
                if (this.mServerSide || this.isLocalhost()) {
                    aIO = aIO.serverSide();
                }
                if (!aNoFiles) {
                    this.loadFiles(aIO, theConn, "remove.msg.info");
                }
            }
            Remove.commitAndClose(theConn, aStartTime, !isInTx);
        }
        catch (StardogException e) {
            theConn.rollback();
            throw e;
        }
    }

    @Override
    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        this.initArgs();
        return this.mDbName;
    }
}

