/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.query.Path;
import com.complexible.common.rdf.query.PathQueryResult;
import com.complexible.common.rdf.query.resultio.PathQueryResultWriter;
import com.complexible.common.rdf.query.resultio.TextPathQueryResultWriter;
import com.complexible.common.rdf.query.resultio.TextTablePathQueryResultWriter;
import com.complexible.common.rdf.query.resultio.TextTableQueryResultWriter;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.BooleanQuery;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.GraphQuery;
import com.complexible.stardog.api.PathQuery;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.api.ReadQuery;
import com.complexible.stardog.api.SelectPlanQuery;
import com.complexible.stardog.api.SelectQuery;
import com.complexible.stardog.api.UpdateQuery;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.ParameterizedQueryCommand;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.query.MalformedQuery;
import com.stardog.stark.query.QueryExecutionFailure;
import com.stardog.stark.query.QueryResults;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultHandlerException;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriters;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import io.airlift.command.Option;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public abstract class QueryWithOutput<T>
extends ParameterizedQueryCommand<T> {
    @Option(description="Result format for RDF [NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD] or SPARQL [SPARQL, JSON, TEXT, TABLE, CSV, TSV, HTML].", name={"-f", "--format"}, title="resultFormat")
    public final String mFormat;

    @Inject
    public QueryWithOutput(PasswordReader theReader) {
        super(theReader);
        this.mFormat = null;
    }

    public static void writeOutput(Connection theConn, Query<?> theQuery, String theFormat, Supplier<Iterable<Namespace>> theNamespaces, long theStartTime, boolean isInTx) {
        block30: {
            boolean aIsFormat;
            boolean bl = aIsFormat = theFormat != null && !theFormat.equals("");
            if (theQuery instanceof BooleanQuery) {
                System.out.println(QueryWithOutput.get("query.msg.result.ask", ((BooleanQuery)theQuery).execute()));
            } else {
                if (theQuery instanceof GraphQuery) {
                    GraphQuery aGraphQuery = (GraphQuery)theQuery;
                    RDFFormat aFormat = RDFFormats.TURTLE;
                    if (aIsFormat && (aFormat = CliUtil.getFormat(theFormat)) == null) {
                        throw new CliException(QueryWithOutput.get("query.error.noformat", theFormat, "NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD"));
                    }
                    try (InputStream in = aGraphQuery.execute((FileFormat)aFormat);){
                        ByteStreams.copy((InputStream)in, (OutputStream)System.out);
                        break block30;
                    }
                    catch (IOException e) {
                        throw new StardogException((Throwable)e);
                    }
                }
                if (theQuery instanceof SelectQuery) {
                    QueryWithOutput.executeTupleQuery((ReadQuery<SelectQueryResult>)((SelectQuery)theQuery), theFormat, theNamespaces, theStartTime);
                } else if (theQuery instanceof SelectPlanQuery) {
                    QueryWithOutput.executeTupleQuery((ReadQuery<SelectQueryResult>)((SelectPlanQuery)theQuery), theFormat, theNamespaces, theStartTime);
                } else if (theQuery instanceof PathQuery) {
                    QueryResultFormat aFormat = TextTableQueryResultWriter.FORMAT;
                    if (aIsFormat) {
                        if (theFormat.toUpperCase().equals("TEXT")) {
                            aFormat = null;
                        } else {
                            aFormat = (QueryResultFormat)OUTPUT_FORMATS.get(theFormat.toUpperCase());
                            if (aFormat == null) {
                                throw new CliException(QueryWithOutput.get("query.error.noformat", theFormat, "SPARQL, JSON, TEXT, TABLE, CSV, TSV, HTML"));
                            }
                        }
                    }
                    if (aFormat != null && aFormat != TextTableQueryResultWriter.FORMAT) {
                        QueryWithOutput.executeTupleQuery((ReadQuery<SelectQueryResult>)((ReadQuery)theQuery), theFormat, theNamespaces, theStartTime);
                    } else {
                        PathQueryResult aPaths = (PathQueryResult)((PathQuery)theQuery).execute();
                        TextTablePathQueryResultWriter aWriter = aFormat == TextTableQueryResultWriter.FORMAT ? new TextTablePathQueryResultWriter((OutputStream)System.out, aPaths.getPathStartVariableNames(), aPaths.getPathEndVariableNames(), aPaths.getEdgeVariableNames(), WriterOptions.defaults()) : new TextPathQueryResultWriter((OutputStream)System.out, (String)aPaths.getPathStartVariableNames().get(0), (String)aPaths.getPathEndVariableNames().get(0));
                        QueryWithOutput.setupResultWriter((QueryResultWriter)aWriter, theNamespaces.get(), theStartTime);
                        QueryWithOutput.renderPaths(aPaths, (PathQueryResultWriter)aWriter);
                    }
                } else if (theQuery instanceof UpdateQuery) {
                    try {
                        if (!isInTx) {
                            theConn.begin();
                        }
                        ((UpdateQuery)theQuery).execute();
                        QueryWithOutput.commitAndClose(theConn, theStartTime, !isInTx);
                    }
                    catch (Exception ex) {
                        UnmodifiableIterator malformed = Iterators.filter(Throwables.getCausalChain((Throwable)ex).iterator(), MalformedQuery.class);
                        if (malformed.hasNext()) {
                            throw new CliException(QueryWithOutput.get("query.error.invalid", CliUtil.getUserMessage((Throwable)malformed.next())));
                        }
                        Throwables.propagateIfPossible((Throwable)ex, StardogException.class);
                        throw new StardogException((Throwable)ex);
                    }
                } else {
                    throw new CliException(QueryWithOutput.get("query.error.invalid", new Object[0]));
                }
            }
        }
    }

    private static void setupResultWriter(QueryResultWriter theWriter, Iterable<Namespace> theNamespaces, long theStartTime) {
        if (theWriter instanceof TextTableQueryResultWriter) {
            TextTableQueryResultWriter aTableWriter = (TextTableQueryResultWriter)theWriter;
            aTableWriter.addNamespaces(theNamespaces);
            aTableWriter.setStartTime(theStartTime);
        }
    }

    private static void executeTupleQuery(ReadQuery<SelectQueryResult> theQuery, String theFormatName, Supplier<Iterable<Namespace>> theNamespaces, long theStartTime) {
        QueryResultFormat aFormat = QueryResultFormats.TEXT_TABLE;
        if (!Strings.isNullOrEmpty((String)theFormatName) && (aFormat = (QueryResultFormat)OUTPUT_FORMATS.get(theFormatName.toUpperCase())) == null) {
            throw new CliException(QueryWithOutput.get("query.error.noformat", theFormatName, "SPARQL, JSON, TEXT, TABLE, CSV, TSV, HTML"));
        }
        if (aFormat.equals((Object)QueryResultFormats.TEXT_TABLE)) {
            QueryWithOutput.renderTuples((SelectQueryResult)theQuery.execute(), aFormat, theNamespaces.get(), theStartTime);
        } else {
            try (InputStream in = theQuery.execute((FileFormat)aFormat);){
                ByteStreams.copy((InputStream)in, (OutputStream)System.out);
            }
            catch (IOException e) {
                throw new StardogException((Throwable)e);
            }
        }
    }

    private static void renderTuples(SelectQueryResult theResults, QueryResultFormat theFormat, Iterable<Namespace> theNamespaces, long theStartTime) {
        Options aOpts = WriterOptions.defaults().set(WriterOptions.XSD_STRING_TO_PLAIN_LITERAL, (Object)true);
        SelectQueryResultWriter aWriter = QueryResultWriters.to((OutputStream)System.out, (QueryResultFormat)theFormat, (Options)aOpts).orElse(null);
        QueryWithOutput.setupResultWriter((QueryResultWriter)aWriter, theNamespaces, theStartTime);
        try {
            QueryResults.report((SelectQueryResult)theResults, (SelectQueryResultHandler)aWriter);
        }
        catch (QueryExecutionFailure | QueryResultHandlerException e) {
            throw new StardogException(e);
        }
    }

    private static void renderPaths(PathQueryResult thePathResult, PathQueryResultWriter theWriter) {
        try {
            theWriter.start();
            theWriter.variables((List)ImmutableList.copyOf((Iterator)Iterators.concat(thePathResult.getPathStartVariableNames().iterator(), (Iterator)Iterators.concat(thePathResult.getEdgeVariableNames().iterator(), thePathResult.getPathEndVariableNames().iterator()))));
            while (thePathResult.hasNext()) {
                Path aPath = (Path)thePathResult.next();
                theWriter.handlePath(aPath);
            }
        }
        catch (QueryExecutionFailure | QueryResultHandlerException e) {
            throw new StardogException(e);
        }
        finally {
            thePathResult.close();
        }
        theWriter.end();
    }
}

