/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="status", description="Displays information about a running query.")
public final class QueryStatus
extends SecureStardogAdminCommand<Void> {
    @Arguments(title={"queryID"}, description="Query ID.", required=true)
    public String mQueryID;

    @Inject
    protected QueryStatus(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        String aQueryID = this.mQueryID;
        QueryInfo aInfo = theConn.getQueryManager().getQuery(aQueryID);
        System.out.append("Username : ").println(aInfo.getUser());
        System.out.append("Database : ").println(aInfo.getDB());
        System.out.format("Started  : %1$tF %1$tr%n", aInfo.getStartTime());
        System.out.append("Elapsed  : ").println(DurationFormat.LONG.format(aInfo.getExecutionTime()));
        System.out.append("Timeout  : ").println(aInfo.getTimeout() > 0L ? DurationFormat.LONG.format(aInfo.getTimeout()) : "N/A");
        System.out.append("Reasoning: ").println(aInfo.isReasoningEnabled());
        switch (aInfo.getStatus()) {
            case KILLED: 
            case TIMEDOUT: {
                System.out.append("Status   : Terminating").println();
            }
        }
        System.out.append("Query    : ").println();
        System.out.println(aInfo.getQuery());
    }
}

