/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.DateTime;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;

@Command(name="list", description="Lists the queries currently running.")
public final class QueryList
extends SecureStardogAdminCommand<Void> {
    private static final String[] COLS = new String[]{"Query ID", "Database", "User", "Query Type", "Elapsed time", "Status", "Timeout"};
    private static final String[] VERBOSE_COLS = new String[]{"Query ID", "Database", "User", "Query Type", "Start time", "Elapsed time", "Status", "Timeout", "Reasoning", "Query"};
    private static final String[] COLS_PACK = new String[]{"Query ID", "Server", "Database", "User", "Query Type", "Elapsed time", "Status", "Timeout"};
    private static final String[] VERBOSE_COLS_PACK = new String[]{"Query ID", "Server", "Database", "User", "Query Type", "Start time", "Elapsed time", "Status", "Timeout", "Reasoning", "Query"};

    @Inject
    protected QueryList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        boolean pack;
        Collection aQueries = theConn.getQueryManager().getAllQueries();
        boolean bl = pack = !this.sameKernelID(aQueries);
        if (!aQueries.isEmpty()) {
            TextTabularOutput aTable = pack ? new TextTabularOutput((OutputStream)System.out, this.mVerbose ? VERBOSE_COLS_PACK : COLS_PACK) : new TextTabularOutput((OutputStream)System.out, this.mVerbose ? VERBOSE_COLS : COLS);
            DurationFormat aDurationFormat = DurationFormat.LONG;
            for (QueryInfo aQuery : aQueries) {
                if (this.mVerbose) {
                    if (pack) {
                        aTable.addRow(new Object[]{aQuery.getID(), aQuery.getKernelID(), aQuery.getDB(), aQuery.getUser(), aQuery.getQueryType(), new DateTime(aQuery.getStartTime()), aDurationFormat.format(aQuery.getExecutionTime()), aQuery.getStatus().toString(), aQuery.getTimeout() > 0L ? aDurationFormat.format(aQuery.getTimeout()) : "N/A", aQuery.isReasoningEnabled(), aQuery.getQuery()});
                        continue;
                    }
                    aTable.addRow(new Object[]{aQuery.getID(), aQuery.getDB(), aQuery.getUser(), aQuery.getQueryType(), new DateTime(aQuery.getStartTime()), aDurationFormat.format(aQuery.getExecutionTime()), aQuery.getStatus().toString(), aQuery.getTimeout() > 0L ? aDurationFormat.format(aQuery.getTimeout()) : "N/A", aQuery.isReasoningEnabled(), aQuery.getQuery()});
                    continue;
                }
                if (pack) {
                    aTable.addRow(new Object[]{aQuery.getID(), aQuery.getKernelID(), aQuery.getDB(), aQuery.getUser(), aQuery.getQueryType(), aDurationFormat.format(aQuery.getExecutionTime()), aQuery.getStatus().toString(), aQuery.getTimeout() > 0L ? aDurationFormat.format(aQuery.getTimeout()) : "N/A"});
                    continue;
                }
                aTable.addRow(new Object[]{aQuery.getID(), aQuery.getDB(), aQuery.getUser(), aQuery.getQueryType(), aDurationFormat.format(aQuery.getExecutionTime()), aQuery.getStatus().toString(), aQuery.getTimeout() > 0L ? aDurationFormat.format(aQuery.getTimeout()) : "N/A"});
            }
            aTable.output();
            System.out.println();
        }
        System.out.println(QueryList.get("query.list.size", aQueries.size()));
    }

    private boolean sameKernelID(Collection<QueryInfo> theQueries) {
        Iterator<QueryInfo> aIterator = theQueries.iterator();
        if (aIterator.hasNext()) {
            String aKernelID = aIterator.next().getKernelID();
            while (aIterator.hasNext()) {
                if (aKernelID.equals(aIterator.next().getKernelID())) continue;
                return false;
            }
        }
        return true;
    }
}

