/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.QueryManager;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;

@Command(name="kill", description="Kills the execution of the given query.", discussion="Stops the execution of the query with the given ID. Multiple queries can be killed by providing multiple query IDs. The user should have permission to kill the specified queries. Superusers can kill any query but ordinary users can only kill the queries they are running.")
public final class QueryKill
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-a", "--all"}, description="Kill all queries flag. If this flag is set, all running queries the user has permission to kill will be killed.")
    public boolean mIsAll = false;
    @Arguments(title={"queryIDs"}, description="List of query IDs to kill.")
    public List<String> mQueryIDs;

    @Inject
    protected QueryKill(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        List<Object> aQueryIDs = null;
        QueryManager aQueryManager = theConn.getQueryManager();
        if (this.mIsAll) {
            aQueryIDs = Lists.newArrayList();
            for (QueryInfo queryInfo : aQueryManager.getAllQueries()) {
                aQueryIDs.add(queryInfo.getID());
            }
        } else if (this.mQueryIDs != null && !this.mQueryIDs.isEmpty()) {
            aQueryIDs = this.mQueryIDs;
        }
        if (aQueryIDs == null || aQueryIDs.isEmpty()) {
            throw new CliException(QueryKill.get("query.kill.no.query", new Object[0]));
        }
        for (String string : aQueryIDs) {
            if (string == null || string.isEmpty() || "-1".equalsIgnoreCase(string.trim())) {
                System.out.println("Invalid query ID, ignoring");
                continue;
            }
            aQueryManager.killQuery(string);
            System.out.println(QueryKill.get("query.kill.success", string));
        }
    }
}

