/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Durations;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.QueryWithOutput;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.EOFException;
import java.util.UUID;
import java.util.function.Supplier;

@Command(name="execute", description="Executes a query against a database; prints the query results on STDOUT.", discussion="", examples={"* Basic query execution:", "    $ stardog query myDb \"select * where { ?s ?p ?o }\"", "", "* Execute a query with some specified bindings:", "    $ stardog query -b s=\"<http://example.org/test>\" p=ex:name o=\"\\\"John Doe\\\"\" -- myDb \"select * {?s ?p ?o}\"", "", "* Execute a query with reasoning:", "    $ stardog query myDb --reasoning \"select ?type where { <urn:an:individual> rdf:type ?type }\"", "", "* Execute a query specified in a file:", "    $ stardog query myDb query.sparql", "", "* Execute a stored query using its name:", "    $ stardog query myDb listNamedGraphs"})
public final class Query
extends QueryWithOutput<Void> {
    @Option(description="Timeout for the query in ms. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds). Timeout value of 0 results in no timeout.", name={"--timeout"}, title="N[h|m|s]")
    public String mTimeout = null;
    @Option(name={"--tx"}, description="Transaction ID this query will run against. A read query will see all the changes done in the transaction before they are committed. An update query will run as part of the given transaction.", title="txID")
    public String mTxId;

    @Inject
    public Query(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        Supplier<Iterable<Namespace>> aNamespaces = () -> CliUtil.namespaces(theConn);
        long aStartTime = System.currentTimeMillis();
        com.complexible.stardog.api.Query<?> aQuery = this.readQuery(q -> CliUtil.query(q, theConn), aNamespaces);
        if (this.mTimeout != null) {
            long aTimeout = Durations.parse((String)this.mTimeout);
            aQuery.timeout(aTimeout);
        }
        if (this.mVerbose) {
            System.out.println(Query.get("query.msg.exec", aQuery.toString()) + "\n");
        }
        try {
            boolean isInTx = this.mTxId != null;
            Query.writeOutput(theConn, aQuery, this.mFormat, aNamespaces, aStartTime, isInTx);
            if (isInTx) {
                Query.closeWithoutRollback(theConn);
            }
        }
        catch (StardogException e) {
            if (Throwables.getRootCause((Throwable)e) instanceof EOFException) {
                throw new StardogException(Query.get("query.partial.response", new Object[0]), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public UUID getTxId() {
        return this.mTxId == null ? null : UUID.fromString(this.mTxId);
    }
}

