/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.List;
import java.util.Map;

@Command(name="set", description="Sets one or more updatable server properties.", examples={"* Set a specific server property:", "    $ stardog-admin property set example.server.property=true", ""})
public class PropertySet
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="The name of the server property", title={"property"})
    public List<String> mProperties;

    @Inject
    public PropertySet(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws Exception {
        Map<String, String> theNvPairs = CliUtil.readNameValuePairs(this.mProperties);
        for (Map.Entry<String, String> entry : theNvPairs.entrySet()) {
            String aMsg = theConn.setProperty(entry.getKey(), entry.getValue());
            System.out.println(aMsg);
        }
    }
}

