/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.MetadataIO;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.ArrayList;

@Command(name="get", description="Gets the value of one or more server properties.", examples={"* Get a server property:", "    $ stardog-admin property get ldap.role.mapping", "", "* Get all server properties set in stardog.properties:", "    $ stardog-admin property get", ""})
public class PropertyGet
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="The name of the server property", title={"property"})
    public String mProperty;

    @Inject
    public PropertyGet(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws Exception {
        ArrayList<String> aProps = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)this.mProperty)) {
            aProps.add(this.mProperty);
        }
        Metadata aPropValues = theConn.getProperty(aProps);
        MetadataIO.writeTable((Metadata)aPropValues, (OutputStream)System.out);
    }
}

