/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.ProcessList;
import com.complexible.stardog.process.ProcessInfo;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.Optional;

@Command(name="status", description="Displays information about a running process.")
public final class ProcessStatus
extends SecureStardogAdminCommand<Void> {
    @Arguments(title={"processID"}, description="Process ID.", required=true)
    public String mProcessID;

    @Inject
    private ProcessStatus(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        ProcessInfo aInfo = theConn.getProcessManager().getProcess(this.mProcessID);
        String FORMAT = "%-12s";
        System.out.format("%-12s", "User:").println(aInfo.getUser());
        System.out.format("%-12s", "Database:").println(aInfo.getDBName());
        System.out.format("%-12s", "Type:").println(aInfo.getType());
        System.out.format("%-12s", "Started:").format("%1$tF %1$tr%n", aInfo.getStartTime());
        System.out.format("%-12s", "Elapsed:").println(DurationFormat.LONG.format(aInfo.getExecutionTime()));
        System.out.format("%-12s", "Status:").println(aInfo.getProcessStatus().toString());
        Optional p = aInfo.progress();
        p.ifPresent(theProgress -> System.out.format("%-12s", "Status:").println(ProcessList.formatProgress(theProgress, this.mVerbose)));
    }
}

