/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.common.base.Progress;
import com.complexible.common.dataexporter.Columns;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.process.ProcessInfo;
import com.complexible.stardog.process.ProcessManager;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Command(name="list", description="Lists the processes currently running.")
public final class ProcessList
extends SecureStardogAdminCommand<Void> {
    private static final String[] COLS = new String[]{"Process ID", "Database", "User", "Type", "Elapsed time", "Status", "Progress"};
    private static final String[] ALL_COLS = new String[]{"Kernel ID", "Process ID", "Database", "User", "Type", "Elapsed time", "Status", "Progress"};
    @Option(name={"-a", "--all"}, description="Show all processes, including internal processes and all processes across Stardog cluster.")
    public boolean mShowAll = false;

    @Inject
    ProcessList(PasswordReader theReader) {
        super(theReader);
    }

    static String formatProgress(Progress p, boolean verbose) {
        String stage = p.stage();
        if (p.hasProgress()) {
            String percent = verbose ? String.format("%d / %d", p.current(), p.maxProgress()) : String.format("%1.1f", Float.valueOf(Math.min(100.0f, 100.0f * (float)p.current() / (float)p.maxProgress()))) + "%";
            return Strings.isNullOrEmpty((String)stage) ? percent : stage + " (" + percent + ")";
        }
        return Strings.isNullOrEmpty((String)stage) ? "N/A" : stage;
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        Options opts = Options.of((com.complexible.common.base.Option)ProcessManager.SHOW_ALL, (Object)this.mShowAll);
        Collection aProcesses = theConn.getProcessManager().getAllProcesses(opts);
        if (!aProcesses.isEmpty()) {
            List cols = Arrays.stream(this.mShowAll ? ALL_COLS : COLS).map(Columns::string).collect(Collectors.toList());
            if (this.mShowAll) {
                cols.add(Columns.string((String)"Cancelable"));
            }
            TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, cols);
            DurationFormat aDurationFormat = DurationFormat.LONG;
            for (ProcessInfo aProcess : aProcesses) {
                if (!this.mShowAll && !aProcess.isManaged()) continue;
                Progress p = (Progress)aProcess.progress().orElse(new Progress.Default(0L, 0L));
                ArrayList<String> list = new ArrayList<String>();
                if (this.mShowAll) {
                    list.add(aProcess.getKernelID());
                }
                list.add(aProcess.getID());
                list.add(aProcess.getDBName());
                list.add(aProcess.getUser());
                list.add(aProcess.getType().toString());
                list.add(aDurationFormat.format(aProcess.getExecutionTime()));
                list.add(aProcess.getProcessStatus().toString());
                list.add(ProcessList.formatProgress(p, this.mVerbose));
                if (this.mShowAll) {
                    list.add(aProcess.isManaged() ? "Yes" : "No");
                }
                aTable.addRow(list.toArray());
            }
            aTable.output();
            System.out.println();
        }
        System.out.println(ProcessList.get("process.list.size", aProcesses.size()));
    }
}

