/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.process.ProcessInfo;
import com.complexible.stardog.process.ProcessManager;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;

@Command(name="kill", description="Kills the execution of the given process.", discussion="Stops the execution of the process with the given ID. Multiple processes can be killed by providing multiple IDs. The user should have permission to kill the specified process. Superusers can kill any process but ordinary users can only kill the processes they are running.")
public final class ProcessKill
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-a", "--all"}, description="Kill all processes flag. If this flag is set, all running processes the user has permission to kill will be killed.")
    public boolean mIsAll = false;
    @Arguments(title={"processIDs"}, description="List of process IDs to kill.")
    public List<String> mProcessIDs;

    @Inject
    protected ProcessKill(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        List<Object> aProcessIDs = null;
        ProcessManager aProcessManager = theConn.getProcessManager();
        if (this.mIsAll) {
            aProcessIDs = Lists.newArrayList();
            for (ProcessInfo processInfo : aProcessManager.getAllProcesses()) {
                if (!processInfo.isManaged()) continue;
                aProcessIDs.add(processInfo.getID());
            }
        } else if (this.mProcessIDs != null && !this.mProcessIDs.isEmpty()) {
            aProcessIDs = this.mProcessIDs;
        }
        if (aProcessIDs == null || aProcessIDs.isEmpty()) {
            throw new CliException(ProcessKill.get("process.kill.no.process", new Object[0]));
        }
        for (String string : aProcessIDs) {
            if (string == null || string.isEmpty() || "-1".equalsIgnoreCase(string.trim())) {
                System.out.println("Invalid process ID, ignoring");
                continue;
            }
            aProcessManager.cancelProcess(string);
            System.out.println(ProcessKill.get("process.kill.success", string));
        }
    }
}

