/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.clarkparsia.license.ExpiredLicenseException;
import com.clarkparsia.license.InvalidLicenseException;
import com.clarkparsia.license.License;
import com.clarkparsia.license.LicenseType;
import com.clarkparsia.license.LicenseValidator;
import com.clarkparsia.license.Licenses;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.StardogCommand;
import com.complexible.stardog.cli.impl.AbstractStardogCommand;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

@Command(name="info", description="Prints information about a Stardog license", examples={"* Print information about a license", "    $ stardog-admin license info /path/to/my/stardog-license-key.bin"})
public final class PrintLicenseInfo
extends AbstractStardogCommand<Void>
implements StardogCommand<Void> {
    @Arguments(required=true, description="The license file to check", title={"license file"})
    private File mFile;

    @Override
    public Void call() throws Exception {
        if (this.mFile == null) {
            throw new CliException("You must specify a file to check.");
        }
        if (!this.mFile.exists()) {
            throw new CliException("The file you specified does not exist.");
        }
        try {
            LicenseValidator aValidator = LicenseValidator.forProduct((String)"stardog").withVersion("12.0.0");
            License aInfo = aValidator.validate(this.mFile);
            System.out.println(String.format("Licensee:\t%s", aInfo.getLicensee()));
            if (!aInfo.getType().equals((Object)LicenseType.Subscription)) {
                System.out.println(String.format("Version:\tStardog %s", aInfo.getVersion()));
            }
            System.out.println(String.format("Type:\t\t%s", aInfo.getType()));
            System.out.println(String.format("Issued:\t\t%s", aInfo.getIssueDate()));
            System.out.println(String.format("Expiration:\t%s", Licenses.getDurationInfo((License)aInfo)));
            System.out.println(String.format("Support:\t%s", Licenses.getDaysLeftWithMaintenance((License)aInfo)));
            System.out.println(String.format("Quantity:\t%s", aInfo.getQuantity()));
            if (this.mVerbose) {
                System.out.println("Product:\t" + aInfo.getProduct());
                System.out.println("Name:\t\t" + aInfo.getLicensee().getName());
                System.out.println("Email:\t\t" + aInfo.getLicensee().getEmail());
                System.out.println("Company:\t" + String.valueOf(aInfo.getLicensee().getCompany()));
                System.out.println("Expires:\t" + String.valueOf(aInfo.getExpirationDate() != null ? aInfo.getExpirationDate() : "Never"));
                System.out.println("Metadata:\t");
                TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, new String[]{"Key", "Value"});
                aTable.setMaxColWidth(200);
                for (Map.Entry aEntry : aInfo.getData().entrySet()) {
                    aTable.addRow(new Object[]{aEntry.getKey(), aEntry.getValue()});
                }
                aTable.output();
            }
        }
        catch (InvalidLicenseException e) {
            throw new CliException("The license is invalid: " + e.getMessage(), e);
        }
        catch (ExpiredLicenseException e) {
            throw new CliException("The license has expired.", e);
        }
        catch (IOException e) {
            throw new CliException("The license could not be read: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new CliException(e);
        }
        return null;
    }
}

