/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.CoreResourceType;
import com.complexible.stardog.security.SecurityResourceType;
import com.complexible.stardog.security.SecurityResourceTypes;
import com.google.common.base.Joiner;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Permission
extends SecureStardogAdminCommand<Void> {
    private static final String[] COLS_SOURCE = new String[]{"Resource Type", "Resource Name", "Permissions", "Source"};
    private static final String[] COLS_NO_SOURCE = new String[]{"Resource Type", "Resource Name", "Permissions"};
    private static final ActionType[] ACTION_ORDER = new ActionType[]{ActionType.CREATE, ActionType.DELETE, ActionType.READ, ActionType.WRITE, ActionType.GRANT, ActionType.REVOKE, ActionType.EXECUTE};
    private static final String[] ACTION_LETTERS = new String[]{"C", "D", "R", "W", "G", "K", "X"};

    protected Permission(PasswordReader theReader) {
        super(theReader);
    }

    private Collection<OutputLine> createOutputLines(Map<String, Collection<com.complexible.stardog.security.Permission>> theStringsBySource) {
        HashMap<OutputLineKey, OutputLine> aMap = new HashMap<OutputLineKey, OutputLine>();
        for (String aSource : theStringsBySource.keySet()) {
            HashMap<Resource, HashSet<ActionType>> aActionTypesByResource = new HashMap<Resource, HashSet<ActionType>>();
            for (com.complexible.stardog.security.Permission aPermission : theStringsBySource.get(aSource)) {
                Resource aResource = new Resource(aPermission.getResourceType(), Joiner.on((char)'\\').join((Iterable)aPermission.getResourceNames()));
                ActionType aAction = aPermission.getActionType();
                if (aAction == null) continue;
                HashSet<ActionType> aActions = (HashSet<ActionType>)aActionTypesByResource.get(aResource);
                if (aActions == null) {
                    aActions = new HashSet<ActionType>();
                    aActionTypesByResource.put(aResource, aActions);
                }
                aActions.add(aAction);
            }
            for (Resource aResource : aActionTypesByResource.keySet()) {
                OutputLineKey key = new OutputLineKey(aResource, (Set)aActionTypesByResource.get(aResource));
                OutputLine line = (OutputLine)aMap.get(key);
                if (line == null) {
                    line = new OutputLine(key.getResource(), key.getActions());
                    aMap.put(key, line);
                }
                line.getSources().add(aSource);
            }
        }
        return aMap.values();
    }

    private static String createActionString(Set<ActionType> theActions) {
        StringBuilder aString = new StringBuilder();
        if (theActions.contains(ActionType.ALL)) {
            for (String aLetter : ACTION_LETTERS) {
                aString.append(aLetter);
            }
        } else {
            for (int i = 0; i < ACTION_ORDER.length; ++i) {
                if (theActions.contains(ACTION_ORDER[i])) {
                    aString.append(ACTION_LETTERS[i]);
                    continue;
                }
                aString.append("-");
            }
        }
        return aString.toString();
    }

    private String createSourcesString(Collection<String> theSources) {
        LinkedList<String> aSources = new LinkedList<String>(theSources);
        Collections.sort(aSources, SourceComparator.INSTANCE);
        StringBuilder aResult = new StringBuilder();
        boolean aFirst = true;
        for (String aSource : aSources) {
            if (aFirst) {
                aFirst = false;
            } else {
                aResult.append(",");
            }
            aResult.append(aSource);
        }
        return aResult.toString();
    }

    protected void outputPermissionStrings(Collection<com.complexible.stardog.security.Permission> thePermissionStrings) {
        HashMap<String, Collection<com.complexible.stardog.security.Permission>> aMap = new HashMap<String, Collection<com.complexible.stardog.security.Permission>>();
        aMap.put("", thePermissionStrings);
        this.outputPermissionStrings(aMap, false);
    }

    protected void outputPermissionStrings(Map<String, Collection<com.complexible.stardog.security.Permission>> theStringsBySource, boolean theShowSource) {
        Collection<OutputLine> aOutputLines = this.createOutputLines(theStringsBySource);
        String[] aCols = theShowSource ? COLS_SOURCE : COLS_NO_SOURCE;
        TextTabularOutput aOutput = new TextTabularOutput((OutputStream)System.out, aCols);
        LinkedList<OutputLine> aOrderedOutputLines = new LinkedList<OutputLine>(aOutputLines);
        Collections.sort(aOrderedOutputLines, new OutputLineComparator());
        for (OutputLine aOutputLine : aOrderedOutputLines) {
            Object[] aData = new Object[aCols.length];
            aData[0] = aOutputLine.getResource().getResourceType().id();
            aData[1] = aOutputLine.getResource().getResourceName();
            aData[2] = Permission.createActionString(aOutputLine.getActions());
            if (theShowSource) {
                aData[3] = this.createSourcesString(aOutputLine.getSources());
            }
            aOutput.addRow(aData);
        }
        aOutput.output();
    }

    private static class Resource {
        private final SecurityResourceType mResourceType;
        private final String mResourceName;

        public Resource(SecurityResourceType theResourceType, String theResourceName) {
            this.mResourceType = theResourceType;
            this.mResourceName = theResourceName;
        }

        public SecurityResourceType getResourceType() {
            return this.mResourceType;
        }

        public String getResourceName() {
            return this.mResourceName;
        }

        public static Resource fromPermissionString(String thePermissionString) {
            SecurityResourceType theResourceType;
            String[] aParts = thePermissionString.split(":");
            String aResourceTypeName = null;
            String aResourceName = "*";
            if (aParts.length > 2) {
                aResourceTypeName = aParts[2];
            } else if (aParts.length > 1 && aParts[1].equals("*")) {
                aResourceTypeName = "*";
            } else {
                return null;
            }
            if (aParts.length > 3) {
                aResourceName = Joiner.on((String)":").join((Object[])Arrays.copyOfRange(aParts, 3, aParts.length));
            }
            if ((theResourceType = SecurityResourceTypes.get((String)aResourceTypeName)) == null) {
                for (CoreResourceType aResourceType : CoreResourceType.values()) {
                    if (!aResourceTypeName.equals(aResourceType.toString())) continue;
                    theResourceType = aResourceType;
                    break;
                }
            }
            return theResourceType != null ? new Resource(theResourceType, aResourceName) : null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mResourceName == null ? 0 : this.mResourceName.hashCode());
            result = 31 * result + (this.mResourceType == null ? 0 : this.mResourceType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)obj;
            if (this.mResourceName == null ? other.mResourceName != null : !this.mResourceName.equals(other.mResourceName)) {
                return false;
            }
            return !(this.mResourceType == null ? other.mResourceType != null : !this.mResourceType.equals((Object)other.mResourceType));
        }
    }

    private static class OutputLineKey {
        private final Resource mResource;
        private final Set<ActionType> mActions;

        public OutputLineKey(Resource theResource, Set<ActionType> theActions) {
            this.mResource = theResource;
            this.mActions = theActions;
        }

        public Resource getResource() {
            return this.mResource;
        }

        public Set<ActionType> getActions() {
            return this.mActions;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mActions == null ? 0 : this.mActions.hashCode());
            result = 31 * result + (this.mResource == null ? 0 : this.mResource.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OutputLineKey)) {
                return false;
            }
            OutputLineKey other = (OutputLineKey)obj;
            if (this.mActions == null ? other.mActions != null : !this.mActions.equals(other.mActions)) {
                return false;
            }
            return !(this.mResource == null ? other.mResource != null : !this.mResource.equals(other.mResource));
        }
    }

    private static class OutputLine {
        private Resource mResource;
        private Set<ActionType> mActions;
        private List<String> mSources;

        public OutputLine(Resource theResource, Set<ActionType> theActions) {
            this.mResource = theResource;
            this.mActions = theActions;
            this.mSources = new LinkedList<String>();
        }

        public Resource getResource() {
            return this.mResource;
        }

        public Set<ActionType> getActions() {
            return this.mActions;
        }

        public List<String> getSources() {
            return this.mSources;
        }
    }

    private static class SourceComparator
    implements Comparator<String> {
        private static SourceComparator INSTANCE = new SourceComparator();

        private SourceComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.startsWith("[")) {
                if (s2.startsWith("[")) {
                    return s1.compareTo(s2);
                }
                return -1;
            }
            if (s2.startsWith("[")) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    private static class OutputLineComparator
    implements Comparator<OutputLine> {
        private static ResourceComparator resourceComparator = new ResourceComparator();
        private static ActionSetComparator actionSetComparator = new ActionSetComparator();

        private OutputLineComparator() {
        }

        @Override
        public int compare(OutputLine o1, OutputLine o2) {
            Resource r2;
            Resource r1 = o1.getResource();
            int aResourceComparison = resourceComparator.compare(r1, r2 = o2.getResource());
            if (aResourceComparison != 0) {
                return aResourceComparison;
            }
            return actionSetComparator.compare(o1.getActions(), o2.getActions());
        }
    }

    private static class ResourceComparator
    implements Comparator<Resource> {
        private ResourceComparator() {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            int aResourceTypeComp = o1.getResourceType().toString().compareTo(o2.getResourceType().toString());
            if (aResourceTypeComp != 0) {
                return aResourceTypeComp;
            }
            return o1.getResourceName().compareTo(o2.getResourceName());
        }
    }

    private static class ActionSetComparator
    implements Comparator<Set<ActionType>> {
        private ActionSetComparator() {
        }

        @Override
        public int compare(Set<ActionType> o1, Set<ActionType> o2) {
            String s1 = Permission.createActionString(o1);
            String s2 = Permission.createActionString(o2);
            return s1.compareTo(s2);
        }
    }

    static class PermissionString {
        private String permissionString;
        private String source;

        public PermissionString(String permissionString, String source) {
            this.permissionString = permissionString;
            this.source = source;
        }

        public String getPermissionString() {
            return this.permissionString;
        }

        public String getSource() {
            return this.source;
        }
    }
}

