/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.security.IllegalPasswordException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.Arrays;

@Command(name="passwd", description="Changes user password.", discussion="Sets a new password for a user, either the current user or a user as specified on the command line. Passwords must be at least four (4) and at most twenty (20) characters long and cannot contain whitespaces.", examples={"* Change the password of the current user, john:", "    $ stardog-admin user passwd --username john", "", "* Change the password of a specific user, bob:", "    $ stardog-admin user passwd --username admin bob"})
public final class Passwd
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="User whose password is to be changed, if different from current user.", title={"target user"})
    @Pattern(regex="^[A-Za-z0-9_]{1}[A-Za-z0-9_/\\-\\@\\.\\+]*$")
    public String mTargetUsername = null;
    @Option(name={"-N", "--new-password"}, description="New password for user. If not provided, the user will be prompted to enter it.", title="new password")
    @Pattern(regex="(.)*")
    public String mNewPassword = null;

    @Inject
    public Passwd(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        boolean aNoPassword;
        String aUsername = null;
        boolean aNoTargetUsername = this.mTargetUsername == null || this.mTargetUsername.isEmpty();
        aUsername = aNoTargetUsername ? this.mUsername : this.mTargetUsername;
        char[] aNewPassword = null;
        boolean bl = aNoPassword = this.mNewPassword == null || this.mNewPassword.isEmpty();
        if (aNoPassword) {
            char[] aNewPasswordRepeat;
            aNewPassword = CliUtil.readPassword(this.mReader, Passwd.get("passwd.new.password", aUsername));
            if (!Arrays.equals(aNewPassword, aNewPasswordRepeat = CliUtil.readPassword(this.mReader, Passwd.get("passwd.new.password.confirm", aUsername)))) {
                throw new CliException(Passwd.get("passwd.confirmation.no.match", new Object[0]));
            }
        } else {
            aNewPassword = this.mNewPassword.trim().toCharArray();
        }
        if (aNewPassword.length == 0) {
            throw new CliException(Passwd.get("passwd.empty.password", new Object[0]));
        }
        if (this.mToken != null) {
            throw new CliException(Passwd.get("passwd.no.token", new Object[0]));
        }
        if (this.mPassword == null) {
            throw new CliException(Passwd.get("passwd.current.password.missing", new Object[0]));
        }
        try {
            theConn.getUserManager().changePassword(aUsername, this.mPassword.toCharArray(), aNewPassword);
            System.out.println(Passwd.get("passwd.success", aUsername));
        }
        catch (IllegalPasswordException e) {
            throw new CliException(Passwd.get("passwd.invalid", new Object[0]));
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)"This should not have happened.");
        }
        catch (ResourceNotFoundException e) {
            throw new CliException(Passwd.get("no.such.user", aUsername));
        }
    }
}

