/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.StardogAdminSecureDatabase;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.index.IndexOptions;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;

@Command(name="optimize", description="Optimizes the indexes of a database for query answering and disk utilization", discussion="Optimizes the indexes of a database for query answering and disk utilization after the database has been heavily modified. If a database has been modified with a large number of additions or removals, some internal structures may become less optimized for query answering. This utility will perform several operations that will help with query answering performance. Which operations are performed depends on the options given. Currently supported options:\n * optimize.statistics={true, false}: recomputes the selectivity statistics which is used for query optimization\n * optimize.compact={true, false}: compacts the index data structures after update operations\n * optimize.vacuum.data={true, false}: frees space by removing quads which have been previously deleted from the database\n * optimize.vacuum.dictionary={true, false}: optimizes internal encoding of RDF terms, removes terms which no longer appear in the data\n * optimize.search={true, false}: recomputes the full-text search index", examples={"* Optimize the database 'myDb':", "    $ stardog-admin db optimize myDb"})
public final class Optimize
extends StardogAdminSecureDatabase<Void> {
    @Option(name={"-o", "--option"}, description="One or more configuration options to be used for optimization. Each option is a 'key=value' pair; multiple options are separated by whitespaces and the string should be quoted, e.g., '-o \"option1=value1 option2=value2\"'. ", title="options", arity=0x7FFFFFFF)
    public List<String> mOptions = Lists.newArrayList();
    @Option(name={"--no-space-check"}, title="no space check", description="Override server's detection of too low storage space.  Low storage space could force a server into read-only mode and subsequent restart.")
    public Boolean mForce = false;
    @Option(name={"--no-throttle"}, title="no throttle", description="Disable Stardog's default configuration to intentionally throttle the optimize operation.")
    public Boolean mOverride = false;

    @Inject
    public Optimize(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        Metadata metaOptions = CliUtil.readOptions(this.mOptions);
        if (this.mForce.booleanValue()) {
            metaOptions.set((MetaProperty)IndexOptions.OPTIMIZE_DISK_SPACE_FORCE, (Object)this.mForce);
        }
        if (this.mOverride.booleanValue()) {
            metaOptions.set((MetaProperty)IndexOptions.OPTIMIZE_THROTTLE_OVERRIDE, (Object)this.mOverride);
        }
        System.out.println(theConn.optimize(this.mDatabase, metaOptions));
    }
}

