/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.StardogAdminSecureDatabase;
import com.google.inject.Inject;
import io.airlift.command.Command;

@Command(name="online", description="Brings a database online.", discussion="Brings an offline database back online so that it can accept connections. Bringing a database online can be expensive depending on how large the database is and what, if any, housekeeping needs to be done in order to get the database ready to handle connections.", examples={"* Bring the database 'foo' online:", "    $ stardog-admin db online foo"})
public final class Online
extends StardogAdminSecureDatabase<Void> {
    @Inject
    public Online(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        String aName = this.mDatabase;
        if (aName == null || aName.trim().equals("")) {
            System.out.println(Online.get("online.error.noname", new Object[0]));
            return;
        }
        theConn.online(aName);
        System.out.println(Online.get("online.success", aName));
    }
}

