/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Durations;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.StardogAdminSecureDatabase;
import com.complexible.stardog.db.DatabaseOptions;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.concurrent.TimeUnit;

@Command(name="offline", description="Takes a database offline.", discussion="Initiates the offlining of a database. The offline operation optionally takes a timeout which, when specified, provides a window where the database is not yet offline. While in this window, no new connections will be accepted but all open connections will be allowed to complete their actions. Once the timeout has been reached, any remaining connections are closed, open transactions are rolled back, and the database is put offline.", examples={"* Take a database 'foo' offline:", "    $ stardog-admin db offline foo", "", "* Take the database 'foo' offline, but wait 15 minutes for open connections to complete their actions:", "    $ stardog-admin db offline --timeout 15m foo ", "", "* Take the database 'foo' offline immediately:", "    $ stardog-admin db offline --timeout 0 foo "})
public final class Offline
extends StardogAdminSecureDatabase<Void> {
    @Option(name={"--timeout"}, description="Timeout in ms to wait before database is put offline. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds). If no timeout is specified, the  default timeout of 5 seconds is used.", title="timeout")
    public String mTimeout = Durations.readable((long)DatabaseOptions.DEFAULT_OFFLINE_TIMEOUT);

    @Inject
    public Offline(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        String aName = this.mDatabase;
        if (aName == null || aName.trim().equals("")) {
            System.out.println(Offline.get("offline.error.noname", new Object[0]));
            return;
        }
        long aTimeOutInMs = Durations.parse((String)this.mTimeout);
        theConn.offline(aName, aTimeOutInMs, TimeUnit.MILLISECONDS);
        System.out.println(Offline.get("offline.success", aName));
    }
}

