/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.io.Files2;
import com.complexible.common.rdf.rio.RDFObfuscator;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.QueryCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.common.base.Charsets;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;

@Command(name="obfuscate", description="Obfuscates the given query", discussion="Obfuscates the given query by replacing all variables, URIs, bnodes, and string literals using a message digest algorithm. This command works in conjunction with the command 'data obfuscate' such that the queries obfuscated with this command can be executed over the obfuscated RDF provided that both commands use the same configuration.", examples={"* Obfuscates the given query:", "    $ stardog query obfuscate myDb query.sparql"})
public final class ObfuscateQuery
extends QueryCommand<Void> {
    @Option(name={"-c", "--config"}, description="Configuration file for obfuscation. This file should exist on the client-side.", title="obfuscation configuration")
    public String mConfig;

    @Inject
    public ObfuscateQuery(PasswordReader theReader) {
        super(theReader);
        this.mDbName = null;
        this.mQuery = null;
        this.mIsFile = false;
        this.mFile = null;
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        boolean aIsQuery;
        String aQueryStr = null;
        boolean bl = aIsQuery = this.mQuery != null && !this.mQuery.equals("");
        if (aIsQuery) {
            aQueryStr = this.mQuery;
        } else if (this.mIsFile) {
            if (!this.mFile.exists()) {
                throw new CliException(ObfuscateQuery.get("explain.error.nofile", new Object[0]));
            }
            try {
                aQueryStr = Files2.toString((Path)this.mFile.toPath(), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new CliException(e);
            }
        } else {
            throw new CliException(ObfuscateQuery.get("explain.error.noquery", new Object[0]));
        }
        boolean aQueryID = this.isQueryID(aQueryStr);
        aQueryStr = aQueryID ? theConn.admin().getQueryManager().getQuery(aQueryStr).getQuery() : CliUtil.cleanQuery(aQueryStr);
        aQueryStr = CliUtil.cleanQuery(aQueryStr);
        try {
            RDFObfuscator aObfuscator = new RDFObfuscator(this.mConfig, (Iterable)theConn.namespaces());
            System.out.println(aObfuscator.obfuscateQuery(aQueryStr));
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    private boolean isQueryID(String theQueryID) {
        try {
            Integer.parseInt(theQueryID);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

