/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.api.Exporter;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.Export;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;

@Command(name="obfuscate", description="Exports the contents of a database in obfuscated RDF.", discussion="Exports RDF data from a database similar to the export command but obfuscates the contents of the RDF by replacing all URIs, bnodes, and string literals using a message digest algorithm. Non-string typed literals (integers, floats, dates, etc.) are left unchanged. The obfuscation is guided by a configuration file. Configurations can specify which URIs and strings will be obfuscated by defining inclusion and exclusion filters.", examples={"* Obfuscate the database 'myDb' using default configuration:", "    $ stardog data obfuscate myDb", "", "* Obfuscate a named graph(s) of the database 'myDb' as TRIG:", "    $ stardog data obfuscate --format TRIG --named-graphs http://mycontext.org/theContextid myDb", "", "* Obfuscate the database 'myDb' using a custom configuration and output to a file in TURTLE:", "    $ stardog data obfuscate --config my_config.ttl myDb export.ttl"})
public final class ObfuscateData
extends Export {
    @Option(name={"-c", "--config"}, description="Configuration file for obfuscation. This file should exist on the client-side.", title="obfuscation configuration")
    public String mConfig;

    @Inject
    public ObfuscateData(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    protected File getObfuscationConfig() {
        return this.mConfig == null ? Exporter.DEFAULT_OBFUSCATION : new File(this.mConfig);
    }

    @Override
    protected boolean shouldObfuscate() {
        return true;
    }
}

