/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.NamespaceCommand;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="remove", description="Removes an existing namespace prefix from a database.")
public final class NamespaceRemove
extends NamespaceCommand<Void> {
    @Option(required=true, name={"--prefix"}, description="Namespace prefix to be removed.", title="prefix")
    public String mPrefix;

    @Inject
    public NamespaceRemove(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        String aPrefix = this.mPrefix;
        try {
            NamespacesInfo aNamespaces = theConn.namespaces();
            boolean aResult = aNamespaces.remove(aPrefix);
            String aMsg = "namespace.remove." + (aResult ? "success" : "fail");
            System.out.println(NamespaceRemove.get(aMsg, aPrefix));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }
}

