/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.NamespaceCommand;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import io.airlift.command.Command;
import java.io.OutputStream;

@Command(name="list", description="Lists the namespace prefixes stored in database in a tabular format.")
public final class NamespaceList
extends NamespaceCommand<Void> {
    @Inject
    public NamespaceList(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public final void execute(Connection theConn) throws StardogException {
        NamespacesInfo aNamespaces = theConn.namespaces();
        String[] aColumns = new String[]{"Prefix", "Namespace"};
        TextTabularOutput aOutput = new TextTabularOutput((OutputStream)System.out, aColumns);
        for (Namespace aNamespace : aNamespaces) {
            aOutput.addRow(new Object[]{aNamespace.prefix(), aNamespace.iri()});
        }
        aOutput.output();
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }
}

