/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.api.impl.NamespacesAccumulator;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.File;
import java.nio.file.Path;
import java.util.List;

@Command(name="import", description="Imports namespace prefixes from an RDF file.", discussion="Imports namespace prefixes from an RDF file that contains prefix declarations into the database, overriding any previous mappings for those prefixes. Only the prefix declarations in the file are processed, the rest of the file is not parsed.")
public final class NamespaceImport
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The subsequent argument is an RDF file.", title={"database", "file"})
    public final List<String> mArgs = Lists.newArrayList();
    private String mDbName;
    private File mFile;

    @Inject
    public NamespaceImport(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        Preconditions.checkNotNull((Object)this.mFile, (Object)NamespaceImport.get("namespace.import.nofile", new Object[0]));
        NamespacesInfo aNamespaces = theConn.namespaces();
        NamespacesAccumulator aNamespacesAccumulator = new NamespacesAccumulator((arg_0, arg_1) -> ((NamespacesInfo)aNamespaces).add(arg_0, arg_1));
        int aImportCount = aNamespacesAccumulator.accumulateNamespaces(RDFStreams.forFiles((Path[])new Path[]{this.mFile.toPath()}));
        System.out.println(NamespaceImport.get("namespace.import.success", aImportCount));
    }

    @Override
    protected String connectionString() {
        if (this.mDbName == null && this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                this.mFile = new File(this.mArgs.get(1));
            }
        }
        return this.mDbName;
    }
}

