/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import com.stardog.stark.io.turtle.TurtleUtil;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;

@Command(name="export", description="Exports the namespace prefixes stored in a database in Turtle or SPARQL format.", examples={"* Exports the namespaces of 'myDb' in Turtle format:", "    $ stardog namespace export myDb", "", "* Exports the namespaces of 'myDb' in SPARQL format:", "    $ stardog namespace export --sparql myDb", "", "* Exports the namespaces of 'myDb' in Turtle format to a specified file:", "    $ stardog namespace export myDb ns.ttl"})
public final class NamespaceExport
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The subsequent argument is the output file.", title={"database", "file"})
    public final List<String> mArgs = Lists.newArrayList();
    @Option(name={"--sparql"}, description="Flag to use SPARQL format for namespaces, i.e. print 'PREFIX' instead of '@prefix' and no period at the end.")
    public boolean mIsSparql = false;
    private String mDbName;
    private File mFile;

    @Inject
    public NamespaceExport(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        try {
            PrintStream out = this.mFile == null ? System.out : new PrintStream(Files.newOutputStream(this.mFile.toPath(), new OpenOption[0]));
            for (Namespace ns : theConn.namespaces()) {
                out.print(this.mIsSparql ? "PREFIX " : "@prefix ");
                out.print(ns.prefix());
                out.print(": <");
                out.print(TurtleUtil.encodeURIString((String)ns.iri()));
                out.print(this.mIsSparql ? ">" : "> . ");
                out.println();
            }
            out.close();
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    protected String connectionString() {
        if (this.mDbName == null && this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                this.mFile = new File(this.mArgs.get(1));
            }
        }
        return this.mDbName;
    }
}

