/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.NamespaceCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="add", description="Adds a new namespace prefix in the database, overriding any previous mapping for the prefix.")
public final class NamespaceAdd
extends NamespaceCommand<Void> {
    @Option(required=true, name={"--prefix"}, description="Namespace prefix to be added.", title="prefix")
    public String mPrefix;
    @Option(required=true, name={"--uri"}, description="Namespace URI to be added.", title="namespace")
    public String mNamespace;

    @Inject
    public NamespaceAdd(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        String aPrefix = this.mPrefix;
        String aNamespace = this.mNamespace;
        try {
            NamespacesInfo aNamespaces = theConn.namespaces();
            boolean aResult = aNamespaces.add(aPrefix, aNamespace);
            String aMsg = "namespace.add." + (aResult ? "success" : "fail");
            System.out.println(NamespaceAdd.get(aMsg, aPrefix));
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }
}

