/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.IO;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ModifyData;
import com.google.common.base.Strings;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import io.airlift.command.Arguments;
import io.airlift.command.Option;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ModifyDataWithFiles
extends ModifyData {
    protected String mDbName = null;
    protected List<String> mFiles = null;
    @Option(name={"--tx"}, description="Transaction ID this update will be part of. This should be the ID of an existing transaction for the given database. If there is a value provided for this option then the transaction will NOT be committed automatically when the command finishes and an explicit `tx commit` will be needed.", title="txID")
    public String mTxId;
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. Subsequent arguments are the list of files whose contents should be added to or removed from the database and, optionally, the named graph(s) for the files. The named graphs are denoted with a @ prefix and all the files specified after a named graph (and before the next graph) are added into or removed from that named graph.", title={"database name", "files"})
    public List<String> mArgs;

    public ModifyDataWithFiles(PasswordReader theReader) {
        super(theReader);
    }

    protected void initArgs() {
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                this.mFiles = this.mArgs.subList(1, this.mArgs.size());
            }
        }
    }

    protected void loadFiles(IO theIO, Connection theConn, String msg) {
        boolean aIsRDF;
        boolean bl = aIsRDF = this.mFormat != null;
        if (aIsRDF) {
            RDFFormat aFormat = CliUtil.getFormat(this.mFormat);
            if (aFormat == null) {
                throw new CliException(ModifyDataWithFiles.get("query.error.noformat", this.mFormat, "NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD"));
            }
            if (this.mCompression != null) {
                FileFormat.Compression aCompression = FileFormat.Compression.of((String)this.mCompression);
                aFormat = RDFFormats.compressedFormat((RDFFormat)aFormat, (FileFormat.Compression)aCompression);
            }
            theIO.format(aFormat);
        } else if (this.mCompression != null) {
            throw new CliException(ModifyDataWithFiles.get("cmd.error.unexpected.compression", new Object[0]));
        }
        IRI aTargetGraph = Strings.isNullOrEmpty((String)this.mNamedGraph) ? null : CliUtil.readIRI(this.mNamedGraph, (Iterable<Namespace>)theConn.namespaces());
        Map<Path, Resource> aFiles = CliUtil.getFilesAndGraphs(this.mFiles);
        for (Map.Entry<Path, Resource> aEntry : aFiles.entrySet()) {
            Path aFile = aEntry.getKey();
            if (!this.mServerSide && !Files.exists(aFile, new LinkOption[0])) {
                throw new CliException(ModifyDataWithFiles.get("file.not.found", aFile));
            }
            Resource aGraph = aEntry.getValue();
            theIO.context((Resource)(aGraph != null ? aGraph : aTargetGraph));
            System.out.println(ModifyDataWithFiles.get(msg, aFile));
            theIO.file(aFile);
        }
    }

    @Override
    public UUID getTxId() {
        return this.mTxId == null ? null : UUID.fromString(this.mTxId);
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }
}

