/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.StardogAdminSecureDatabase;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.MetadataCliUtils;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.nio.file.Paths;
import java.util.List;

@Command(name="set", description="Sets one or more configuration options for database.", examples={"* Set a specific property of myDB:", "    $ stardog-admin metadata set -o virtual.transparency=true -- myDB", ""})
public final class MetadataSet
extends StardogAdminSecureDatabase<Void> {
    @Option(name={"-o", "--option"}, description="One or more configuration options to set for a database. Each option is a 'key=value' pair; multiple options are separated by whitespaces, e.g., '-o \"option1=value1 option2=value2\"'. ", title="options", arity=0x7FFFFFFF)
    public List<String> mOptions = Lists.newArrayList();
    @Option(name={"-c", "--config"}, title="config", description="Database configuration file containing one or more configuration options to set. Options specified explicitly on the command line with -o, --options override those specified in the configuration file. The configuration file should be in Java properties format.")
    public String mConfigFile;

    @Inject
    public MetadataSet(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws Exception {
        String aMsg = "";
        if (this.mOptions.isEmpty() && this.mConfigFile == null) {
            throw new CliException("No configuration option specified");
        }
        Metadata aOptions = this.mConfigFile == null ? Metadata.create() : MetadataCliUtils.read(Paths.get(this.mConfigFile, new String[0]), MetadataCliUtils.MetadataFormat.PROPERTIES);
        CliUtil.readOptions(this.mOptions, aOptions);
        for (ConfigProperty aOption : Iterables.filter((Iterable)aOptions, ConfigProperty.class)) {
            aMsg = theConn.set(this.mDatabase, (MetaProperty)aOption, aOptions.get((MetaProperty)aOption));
            System.out.println(aMsg);
        }
    }
}

