/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.StardogAdminSecureDatabase;
import com.complexible.stardog.cli.impl.MetadataCliUtils;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.Metadata;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;

@Command(name="get", description="Gets the value of one or more database configuration options.", examples={"* Get a specific property of myDB:", "    $ stardog-admin metadata get -o virtual.transparency myDB", "", "* Get all properties of myDB:", "    $ stardog-admin metadata get myDB", ""})
public final class MetadataGet
extends StardogAdminSecureDatabase<Void> {
    @Option(name={"-o", "--option"}, description="Gets the value of one or more database configuration options. If no arguments are provided, all known configuration options will be printed to STDOUT. Only the option names should be provided. Multiple configuration options should be space separated: '-o option1 option2'.", title="options")
    public List<String> mOptions;
    @Option(name={"--output-format"}, description="Format for output. Valid values are [BINARY, JSON, PROPERTIES, RDF]. If no output format is specified the output will be printed in a human-readable tabular output format. If BINARY output is selected the output should be directed to a file.")
    public String outputFormat = null;
    @Option(name={"--non-default"}, description="Print only the options that has value different than the default", arity=0)
    public boolean mNonDefault = false;

    @Inject
    public MetadataGet(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws Exception {
        boolean aHasOptions = this.mOptions != null && !this.mOptions.isEmpty();
        Iterable aOptions = !aHasOptions ? MetaProperties.allProperties() : Lists.newArrayList((Iterable)Iterables.transform(this.mOptions, MetaProperties::get));
        Metadata aOptionValues = theConn.get(this.mDatabase, aOptions);
        if (this.mNonDefault) {
            aOptionValues = MetadataCliUtils.filterDefaultOptions(aOptionValues);
        }
        MetadataCliUtils.write(aOptionValues, this.outputFormat);
    }
}

