/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.cli.impl.AbstractStardogCommand;
import com.complexible.stardog.cli.impl.MetadataCliUtils;
import com.complexible.stardog.metadata.Metadata;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.IOException;
import java.nio.file.Paths;

@Command(name="convert", description="Converts the database metadata between different formats.", discussion="Reads database metadata from a file and prints the contents in requested format to the console. If no output format is specified the output will be printed in a human-readable tabular output format. ", examples={"Print metadata as a human-readable table:", "$ stardog-admin metadata convert index.metadata", "", "Convert metadata from Java properties format to json:", "$ stardog-admin metadata convert --input-format properties --output-format json db_config.props", ""})
public final class MetadataConvert
extends AbstractStardogCommand<Void> {
    @Option(name={"--output-format"}, description="Format for output. Valid values are [BINARY, JSON, PROPERTIES, RDF]. If no output format is specified the output will be printed in a human-readable tabular output format. If BINARY output is selected the output should be directed to a file.")
    public String outputFormat = null;
    @Option(name={"--input-format"}, description="Format for input. Valid values are [BINARY, JSON, PROPERTIES, RDF]. If no input format is provided the format will be guessed from the file extension. The BINARY metadata format is used in database backups. The JSON format is used by the HTTP API. The PROPERTIES format is used by the CLI commands. The RDF format is used within the system database.")
    public String inputFormat = null;
    @Option(name={"--non-default"}, description="Print only the database options that has value different than the default", arity=0)
    public boolean mNonDefault = false;
    @Arguments(description="Input file containing database metadata", title={"Input file"}, required=true)
    public String inputFile;

    @Inject
    public MetadataConvert() {
    }

    @Override
    public Void call() throws IOException {
        Metadata metadata = MetadataCliUtils.read(Paths.get(this.inputFile, new String[0]), this.inputFormat);
        if (this.mNonDefault) {
            metadata = MetadataCliUtils.filterDefaultOptions(metadata);
        }
        MetadataCliUtils.write(metadata, this.outputFormat);
        return null;
    }
}

