/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteReaders;
import com.complexible.common.io.ByteWriter;
import com.complexible.common.io.ByteWriters;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.MetadataIO;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.stardog.http.io.JSON;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.StatementPattern;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.vocabs.RDF;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public final class MetadataCliUtils {
    public static final String OUTPUT_FORMAT_DESC = "Format for output. Valid values are [BINARY, JSON, PROPERTIES, RDF]. If no output format is specified the output will be printed in a human-readable tabular output format. If BINARY output is selected the output should be directed to a file.";
    public static final String INPUT_FORMAT_DESC = "Format for input. Valid values are [BINARY, JSON, PROPERTIES, RDF]. If no input format is provided the format will be guessed from the file extension. The BINARY metadata format is used in database backups. The JSON format is used by the HTTP API. The PROPERTIES format is used by the CLI commands. The RDF format is used within the system database.";
    private static final String SYSTEM_NS = "http://system.stardog.com/";
    private static final IRI INDEX = Values.iri((String)"http://system.stardog.com/", (String)"Index");

    public static Metadata read(Path inputFile, String inputFormatName) throws IOException {
        MetadataFormat inputFormat = Optional.ofNullable(inputFormatName).map(MetadataCliUtils::getFormat).orElse(MetadataCliUtils.getFormatForFilename(inputFile.toString()));
        return MetadataCliUtils.read(inputFile, inputFormat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Metadata read(Path inputFile, MetadataFormat inputFormat) throws IOException {
        try (InputStream in = Files.newInputStream(inputFile, new OpenOption[0]);){
            switch (inputFormat.ordinal()) {
                case 2: {
                    RDFFormat format = RDFFormats.forFile((String)inputFile.toString(), (RDFFormat)RDFFormats.TRIG);
                    Set stmts = RDFParsers.read((InputStream)in, (RDFFormat)format);
                    Set subjects = stmts.stream().filter(StatementPattern.po((IRI)RDF.TYPE, (Value)INDEX)).map(Statement::subject).collect(Collectors.toSet());
                    Preconditions.checkArgument((subjects.size() == 1 ? 1 : 0) != 0, (Object)"One and only one subject with rdf:type system:Index is expected in the RDF input");
                    Metadata metadata = MetadataIO.readGraph((Set)stmts, (Resource)((Resource)subjects.iterator().next()));
                    return metadata;
                }
                case 0: {
                    byte[] bytes = ByteStreams.toByteArray((InputStream)in);
                    Metadata metadata = MetadataIO.readBytes((ByteReader)ByteReaders.of((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length));
                    return metadata;
                }
                case 1: {
                    Metadata metadata = Metadata.create();
                    MetadataIO.readProperties((Metadata)metadata, (InputStream)in);
                    return metadata;
                }
                case 3: {
                    Metadata metadata = (Metadata)JSON.GSON.fromJson((Reader)new InputStreamReader(in), Metadata.class);
                    return metadata;
                }
                default: {
                    throw new RuntimeException("Unrecognized input format: " + String.valueOf((Object)inputFormat));
                }
            }
        }
    }

    public static Metadata filterDefaultOptions(Metadata metadata) {
        return MetaProperties.filter((Metadata)metadata, p -> !Objects.equals(p.getDefaultValue(), metadata.get(p)) && !Objects.equals(p.getSystemDefaultValue(), metadata.get(p)));
    }

    public static void write(Metadata metadata, String outputFormatName) throws IOException {
        if (outputFormatName == null) {
            MetadataIO.writeTable((Metadata)metadata, (OutputStream)System.out);
        } else {
            MetadataFormat outputFormat = MetadataCliUtils.getFormat(outputFormatName);
            switch (outputFormat.ordinal()) {
                case 2: {
                    IRI subj = Values.iri((String)SYSTEM_NS, (String)UUID.randomUUID().toString());
                    HashSet stmts = Sets.newHashSet();
                    stmts.add(Values.statement((Resource)subj, (IRI)RDF.TYPE, (Value)INDEX));
                    MetadataIO.writeGraph((Metadata)metadata, (Set)stmts, (IRI)subj, n -> Values.iri((String)(SYSTEM_NS + n)));
                    RDFWriters.write((OutputStream)System.out, (RDFFormat)RDFFormats.TURTLE, (Iterable)stmts);
                    break;
                }
                case 0: {
                    BufferedOutputStream out = new BufferedOutputStream(System.out);
                    MetadataIO.writeBytes((Metadata)metadata, (ByteWriter)ByteWriters.asByteWriter((OutputStream)out));
                    out.flush();
                    break;
                }
                case 1: {
                    MetadataIO.writeProperties((Metadata)metadata, (OutputStream)System.out);
                    break;
                }
                case 3: {
                    System.out.println(JSON.GSON.toJson((Object)metadata));
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized output format: " + String.valueOf((Object)outputFormat));
                }
            }
        }
    }

    public static MetadataFormat getFormatForFilename(String fileName) {
        if (fileName.endsWith(".properties")) {
            return MetadataFormat.PROPERTIES;
        }
        if (fileName.endsWith(".json")) {
            return MetadataFormat.JSON;
        }
        if (RDFFormats.forFile((String)fileName).isPresent()) {
            return MetadataFormat.RDF;
        }
        return MetadataFormat.BINARY;
    }

    public static MetadataFormat getFormat(String formatName) {
        return (MetadataFormat)((Object)Enums.getIfPresent(MetadataFormat.class, (String)formatName.toUpperCase()).toJavaUtil().orElseThrow(() -> new RuntimeException("Unrecognized format: " + formatName)));
    }

    public static enum MetadataFormat {
        BINARY,
        PROPERTIES,
        RDF,
        JSON;

    }
}

