/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;

@Command(name="list", description="Lists all databases.")
public final class ListDbs
extends SecureStardogAdminCommand<Void> {
    @Inject
    public ListDbs(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        LinkedList aDatabases = new LinkedList(theConn.list());
        Collections.sort(aDatabases);
        if (aDatabases.isEmpty()) {
            System.out.println(ListDbs.get("list.no.databases", new Object[0]));
        } else {
            TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, new String[]{"Databases"});
            for (String aDatabase : aDatabases) {
                aTable.addRow(new Object[]{aDatabase});
            }
            aTable.output();
        }
    }
}

