/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Memory;
import com.complexible.common.base.Numbers;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.cli.StardogCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.common.collect.Lists;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.MoreFiles;
import com.stardog.stark.Namespace;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.CompressedRDFFormat;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.io.WriterOptions;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.BiPredicate;

@Command(name="split", description="Splits a given RDF file to multiple files", examples={"* Splits input file into files with 10K triples each.", "    $ stardog file split -t 10K input.rdf", "", "* Splits input file to 2MB files. The output files will be gzip-compressed Turtle files.", "    $ stardog file split -b 2M input.ttl.gz", "", "* Splits input file to 1M triples. The output files will be in bzip-compressed N-Triples format and named out001.nt.bz2, out002.nt.bz2, and so on", "    $ stardog file split -t 1M --prefix out --suffix 3 --format nt --compressed bz2 input.ttl", ""})
public class FileSplit
implements StardogCommand<Void> {
    @Option(name={"-b"}, title="byteCount[k|m]", description="Create smaller files byteCount bytes in length. Suffix 'k', 'm', or 'g' can be used after the byteCount to indicate kilobyte, megabyte, or gigabyte respectively.")
    public String mByteCount;
    @Option(name={"-t"}, title="tripleCount", description="Create smaller files with tripleCount triples")
    public String mTripleCount;
    @Option(name={"-f", "--format"}, description="RDF Format for the output. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD. By default output files will have same format as input file.", title="rdf format")
    public String mFormat;
    @Option(name={"--compression"}, description="Compression format [GZIP, BZ2] for the exported data.", title="Compression")
    public String mCompression;
    @Option(name={"--prefix"}, description="Prefix for the output file names. By default the name of the input file is used as the prefix.", title="prefix")
    public String mPrefix;
    @Option(name={"--suffix"}, description="Number of letters to form the suffix of the file name.", title="suffix")
    public int mSuffixLength = 2;
    @Arguments(description="Input file to split.", title={"inputFile"}, required=true)
    private String mFileName;

    @Override
    public Void call() throws Exception {
        FileFormat.Compression outputCompression;
        RDFFormat baseOutputFormat;
        BiPredicate<Long, Long> aShouldSplit;
        Path aFile = Paths.get(this.mFileName, new String[0]);
        if (this.mTripleCount != null) {
            long aTripleLimit = Numbers.fromReadable((String)this.mTripleCount).longValue();
            aShouldSplit = (tripleCount, fileSize) -> tripleCount >= aTripleLimit;
        } else {
            long aByteLimit = this.mByteCount == null ? Files.size(aFile) / 10L : Memory.fromReadable((String)this.mByteCount);
            aShouldSplit = (tripleCount, fileSize) -> fileSize >= aByteLimit;
        }
        RDFFormat outputFormat = CliUtil.getFormat(this.mFormat, aFile.toFile());
        boolean isCompressedFormat = outputFormat instanceof CompressedRDFFormat;
        RDFFormat rDFFormat = baseOutputFormat = isCompressedFormat ? ((CompressedRDFFormat)outputFormat).baseFormat() : outputFormat;
        FileFormat.Compression compression = isCompressedFormat && this.mFormat == null ? ((CompressedRDFFormat)outputFormat).compression() : (outputCompression = this.mCompression != null ? FileFormat.Compression.of((String)this.mCompression.toUpperCase()) : null);
        if (this.mPrefix == null) {
            String filename = this.mFileName;
            RDFFormat inputFormat = RDFFormats.forFile((String)filename, null);
            if (inputFormat instanceof CompressedRDFFormat) {
                filename = filename.substring(0, filename.length() - ((CompressedRDFFormat)inputFormat).compression().extension().length());
            }
            this.mPrefix = MoreFiles.getNameWithoutExtension((Path)Paths.get(filename, new String[0]));
        }
        final String fileNameFormat = this.mPrefix + "%0" + this.mSuffixLength + "d." + outputFormat.defaultExtension() + (outputCompression != null ? outputCompression.extension() : "");
        RDFStreams.forFile((Path)aFile).config(ParserConfigs.lax()).parse((RDFHandler)new AbstractRDFHandler(this){
            List<Namespace> namespaces = Lists.newArrayList();
            int fileCount = 1;
            long tripleCount = 0L;
            OutputStream out;
            CountingOutputStream counter;
            RDFWriter writer;

            public void namespace(String prefix, String uri) {
                if (this.writer == null) {
                    this.namespaces.add(Values.namespace((String)prefix, (String)uri));
                }
            }

            public void handle(Statement stmt) {
                if (this.writer == null || aShouldSplit.test(this.tripleCount, this.counter.getCount())) {
                    this.startNewFile();
                }
                this.writer.handle(stmt);
                ++this.tripleCount;
            }

            public void end() {
                this.finishLastFile();
            }

            private void finishLastFile() {
                try {
                    if (this.writer != null) {
                        this.writer.end();
                        this.out.close();
                    }
                }
                catch (Exception e) {
                    throw new RDFHandlerException((Throwable)e);
                }
            }

            private void startNewFile() throws RDFHandlerException {
                try {
                    this.finishLastFile();
                    this.tripleCount = 0L;
                    String fileName = String.format(fileNameFormat, this.fileCount++);
                    System.out.println("Writing file " + fileName);
                    this.counter = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(fileName)));
                    this.out = outputCompression == null ? this.counter : outputCompression.compress((OutputStream)this.counter);
                    this.writer = (RDFWriter)RDFWriters.to((OutputStream)this.out, (RDFFormat)baseOutputFormat, (Options)WriterOptions.namespaces((Iterable)new NamespacesImpl(this.namespaces))).get();
                    this.writer.start();
                }
                catch (Exception e) {
                    throw new RDFHandlerException((Throwable)e);
                }
            }
        });
        return null;
    }
}

