/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.common.rdf.rio.RDFObfuscator;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.common.rdf.rio.RDFWriters2;
import com.complexible.stardog.cli.StardogCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriter;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

@Command(name="obfuscate", description="Obfuscates the contents of the given RDF file", discussion="Obfuscates the contents of the file by replacing all URIs, bnodes, and string literals using a message digest algorithm. Non-string typed literals (integers, floats, dates, etc.) are left unchanged. The obfuscation is guided by a configuration file. Configurations can specify which URIs and strings will be obfuscated by defining inclusion and exclusion filters.", examples={"* Obfuscate input file.", "    $ stardog file obfuscate input.rdf", "", "* Obfuscate input file using a custom configuration and output in TURTLE format:", "    $ stardog file obfuscate --config my_config.ttl --format turtle input.rdf"})
public class FileObfuscate
implements StardogCommand<Void> {
    @Option(name={"-f", "--format"}, title="rdf format", description="RDF Format for the output. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD. By default output files will have the same format as the first input file.")
    public String mFormat;
    @Option(name={"-c", "--config"}, description="Configuration file for obfuscation", title="obfuscation configuration")
    public String mConfig;
    @Arguments(description="Input file to obfuscate.", title={"inputFile"}, required=true)
    private String mFileName;

    @Override
    public Void call() throws Exception {
        Path aFile = Paths.get(this.mFileName, new String[0]);
        RDFFormat aFormat = CliUtil.getFormat(this.mFormat, aFile.toFile());
        RDFObfuscator aObfuscator = new RDFObfuscator(this.mConfig);
        RDFWriter aWriter = RDFWriters2.createObfuscatedWriter((RDFFormat)aFormat, (OutputStream)System.out, (RDFObfuscator)aObfuscator);
        RDFStreams.forFile((Path)aFile).config(ParserConfigs.lax()).parse((RDFHandler)aWriter);
        return null;
    }
}

