/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.cli.StardogCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

@Command(name="cat", description="Concatenate and print RDF files in desired format", examples={"* Concatenate input files and output in Turtle format.", "    $ stardog file cat input1.ttl input2.nt input3.rdf", "", "* Concatenate input files and output in RDF/XML format.", "    $ stardog file cat -f rdf/xml input1.ttl input2.nt input3.rdf", "", "* Concatenate input files and output in gzipped Turtle format.", "    $ stardog file cat -f rdf/xml input1.ttl.gz input2.ttl.gz > output.ttl.gz"})
public class FileCat
implements StardogCommand<Void> {
    @Option(name={"-f", "--format"}, title="rdf format", description="RDF Format for the output. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD. By default output files will have the same format as the first input file.")
    public String mFormat;
    @Arguments(description="Input files to concatenate.", title={"inputFile"}, required=true)
    private List<String> mFileNames;

    @Override
    public Void call() throws Exception {
        List aFiles = this.mFileNames.stream().map(name -> Paths.get(name, new String[0])).collect(Collectors.toList());
        RDFFormat aFormat = CliUtil.getFormat(this.mFormat, ((Path)aFiles.get(0)).toFile());
        RDFWriter writer = (RDFWriter)RDFWriters.to((OutputStream)System.out, (RDFFormat)aFormat).get();
        RDFStreams.forFiles(aFiles).config(ParserConfigs.lax()).parse((RDFHandler)writer);
        return null;
    }
}

