/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.Contexts;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.Exporter;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.stardog.stark.Resource;
import com.stardog.stark.Values;
import com.stardog.stark.io.CompressedRDFFormat;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="export", description="Exports the contents of a database in RDF.", discussion="Exports the database in the specified format to the specified output file, else to STDOUT. By default, only the default graph will be exported.  To export the entire database, or a specific set of named graphs, use the -g/--named-graph parameter to specify the graphs to export. If no format is specified, the format is determined from the output file name; otherwise, TURTLE is the default. Exports of large databases should be performed on the server using the --server-side flag.  This will save the RDF using the specified format in the export directory for the server.  The default server export directory is '.exports' in your $STARDOG_HOME but can be changed via 'export.dir' in the stardog.properties file.", examples={"* Export the database 'myDb' as NTRIPLES:", "    $ stardog data export --format NTRIPLES myDb", "", "* Export the entire database 'myDb' to a file in TURTLE:", "    $ stardog data export --named-graphs ALL -- myDb export.ttl", "", "* Export two named graphs of the database 'myDb' as TRIG:", "    $ stardog data export --named-graphs http://examples.org/graph1 http://examples.org/graph2 --format TRIG myDb", "", "* Export the database 'myDb' to a file in TURTLE:", "    $ stardog data export myDb export.ttl", "", "* Export the database 'myDb' to a gzipped file in TURTLE:", "    $ stardog data export myDb export.ttl.gz", "", "* Export the entire database 'myDb' as TRIG to a file on the server", "    $ stardog data export --named-graphs ALL --format TRIG --server-side myDb"})
public class Export
extends ConnectionCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Export.class);
    public static final RDFFormat DEFAULT_FORMAT = RDFFormats.TURTLE;
    @Option(name={"-f", "--format"}, description="RDF Format [NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD] for the exported data.", title="RDF Format")
    public String mFormat;
    @Option(name={"--compression"}, description="Compression format [GZIP, BZ2] for the exported data.", title="Compression")
    public String mCompression;
    @Option(name={"-g", "--named-graph", "--named-graphs"}, description="Named graph(s) to export.  Multiple options are separated by whitespaces, e.g., '-g \"urn:context1 urn:context2\"'. The keyword ALL can be used if all named graphs in the db are desired, and the keyword DEFAULT can be used to export the default graph. Virtual graphs can be exported by name, but are not included when ALL is specified. When used as the last option, values should be followed by '--' to denote the end of the named graphs.\"", title="export named graph(s)", arity=0x7FFFFFFF)
    public List<String> mGraph;
    @Option(name={"-s", "--server-side"}, description="Export the data to the server", title="Server Side", arity=0)
    public boolean mServerSide = false;
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The second argument is the file to write the output to; if not specified, the output is written to STDOUT. No file can be specified for server-side exports; the output will be written to a file under the STARDOG_HOME/.exports directory.", title={"dbname", "export file"})
    public List<String> mArgs;
    private String mDbName = null;
    private File mFile = null;
    private boolean mIsFile = false;

    @Inject
    public Export(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        OutputStream aOutput = System.out;
        if (this.mIsFile && this.mServerSide) {
            throw new CliException("File arguments are not allowed for server-side exports");
        }
        try {
            boolean aIsFormat;
            RDFFormat aFormat = DEFAULT_FORMAT;
            boolean bl = aIsFormat = !Strings.isNullOrEmpty((String)this.mFormat);
            if (aIsFormat) {
                aFormat = CliUtil.getFormat(this.mFormat);
                if (aFormat == null) {
                    throw new StardogException("Unrecognized output format: " + this.mFormat);
                }
            } else if (this.mIsFile) {
                aFormat = RDFFormats.forFile((String)this.mFile.getName(), (RDFFormat)DEFAULT_FORMAT);
            }
            if (!Strings.isNullOrEmpty((String)this.mCompression)) {
                try {
                    FileFormat.Compression aCompression = FileFormat.Compression.of((String)this.mCompression.toUpperCase());
                    aFormat = new CompressedRDFFormat(aFormat, aCompression);
                }
                catch (IllegalArgumentException e) {
                    throw new StardogException("Unrecognized compression format: " + this.mCompression, (Throwable)e);
                }
            }
            Exporter aExporter = theConn.export().format(aFormat);
            if (this.shouldObfuscate()) {
                aExporter.obfuscated(this.getObfuscationConfig());
            }
            ArrayList aContexts = Lists.newArrayList();
            if (this.mGraph != null) {
                for (String aValue : this.mGraph) {
                    if (aValue == null || aValue.equals("")) continue;
                    if (aValue.equalsIgnoreCase("ALL")) {
                        aContexts.add(Contexts.LOCAL);
                        continue;
                    }
                    if (aValue.equalsIgnoreCase("DEFAULT")) {
                        aContexts.add(Contexts.DEFAULT);
                        continue;
                    }
                    aContexts.add(Values.iri((String)aValue));
                }
                aExporter.context((Collection)aContexts);
            } else if (RDFFormats.supportsContexts((RDFFormat)aFormat)) {
                aExporter.context((Resource)Contexts.LOCAL, new Resource[0]);
            } else {
                aExporter.context((Resource)Contexts.DEFAULT, new Resource[0]);
            }
            if (this.mServerSide) {
                String aResult = aExporter.toServer();
                System.out.println(aResult);
            } else {
                if (this.mIsFile) {
                    aOutput = Files.newOutputStream(this.mFile.toPath(), new OpenOption[0]);
                }
                Stopwatch aStopwatch = Stopwatch.createStarted();
                aExporter.to(aOutput);
                aStopwatch.stop();
                if (this.mFile != null) {
                    System.out.println(Export.get("export.msg.success", aFormat.name(), this.mFile.getName(), aStopwatch));
                }
            }
        }
        catch (IOException e) {
            throw new StardogException("Could not create file for exported data", (Throwable)e);
        }
        catch (StardogException e) {
            throw new CliException(e);
        }
        finally {
            if (aOutput != System.out) {
                try {
                    aOutput.close();
                }
                catch (IOException e) {
                    LOGGER.warn("There was an error while closing the file");
                }
            }
        }
    }

    protected boolean shouldObfuscate() {
        return false;
    }

    protected File getObfuscationConfig() {
        return Exporter.DEFAULT_OBFUSCATION;
    }

    @Override
    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                this.mFile = new File(this.mArgs.get(1));
                this.mIsFile = true;
            }
        }
        return this.mDbName;
    }
}

